/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.humdiseaselist.DiseaseIdListRetrieval;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class DiseaseCommentStructuredHandler
implements GenericHandler<DiseaseCommentStructured, CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final GenericHandler<Disease, CommentType.Disease> diseaseHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public DiseaseCommentStructuredHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler, DiseaseIdListRetrieval diseaseIdListRetrieval) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setDiseaseIdListRetrieval(diseaseIdListRetrieval);
        this.diseaseHandler = itemFactory.buildDiseaseHandler();
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, evidenceReferenceHandler, true);
    }

    @Override
    public DiseaseCommentStructured fromXmlBinding(CommentType xmlComment) {
        if (xmlComment == null) {
            return null;
        }
        DiseaseCommentStructured comment = (DiseaseCommentStructured)this.commentFactory.buildComment(uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType.DISEASE);
        if (xmlComment.getMolecule() != null) {
            comment.setMolecule(xmlComment.getMolecule().getValue());
        }
        if (xmlComment.getDisease() != null) {
            comment.setDisease(this.diseaseHandler.fromXmlBinding(xmlComment.getDisease()));
        }
        if (!xmlComment.getText().isEmpty()) {
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            for (EvidencedStringType evStr : xmlComment.getText()) {
                EvidencedValue evValue = this.evidencedValueHandler.fromXmlBinding(evStr);
                evValues.add(evValue);
            }
            comment.getNote().setTexts(evValues);
        }
        if (!xmlComment.getEvidence().isEmpty()) {
            comment.getDisease().getDescription().getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(xmlComment.getEvidence()));
        }
        return comment;
    }

    @Override
    public CommentType toXmlBinding(DiseaseCommentStructured comment) {
        DiseaseNote note;
        List<Integer> evs;
        if (comment == null) {
            return null;
        }
        CommentType xmlComment = this.objectFactory.createCommentType();
        xmlComment.setType(comment.getCommentType().toDisplayName().toLowerCase());
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setValue(comment.getMolecule());
            xmlComment.setMolecule(mol);
        }
        if (comment.hasDefinedDisease()) {
            xmlComment.setDisease(this.diseaseHandler.toXmlBinding(comment.getDisease()));
            List<EvidenceId> evidenceIds = comment.getDisease().getDescription().getEvidenceIds();
            if (evidenceIds != null && !evidenceIds.isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
                xmlComment.getEvidence().addAll(evs);
            }
        }
        if ((note = comment.getNote()) != null && !note.getTexts().isEmpty()) {
            evs = note.getTexts().iterator();
            while (evs.hasNext()) {
                EvidencedValue evValue = (EvidencedValue)evs.next();
                EvidencedStringType evidencedStringType = this.evidencedValueHandler.toXmlBinding(evValue);
                xmlComment.getText().add(evidencedStringType);
            }
        }
        if (!comment.getEvidenceIds().isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(comment.getEvidenceIds())).isEmpty()) {
            xmlComment.getEvidence().addAll((Collection<Integer>)evs);
        }
        return xmlComment;
    }
}

