/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CofactorType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CofactorHandler
implements GenericHandler<Cofactor, CofactorType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;

    public CofactorHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    @Override
    public Cofactor fromXmlBinding(CofactorType xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        Cofactor cofactor = this.commentFactory.buildCofactor();
        cofactor.setName(xmlObject.getName());
        CofactorReference xref = this.commentFactory.buildCofactorReference();
        xref.setReferenceId(xmlObject.getDbReference().getId());
        xref.setCofactorReferenceType(CofactorReferenceType.typeOf(xmlObject.getDbReference().getType()));
        cofactor.setCofactorReference(xref);
        if (!xmlObject.getEvidence().isEmpty()) {
            cofactor.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(xmlObject.getEvidence()));
        }
        return cofactor;
    }

    @Override
    public CofactorType toXmlBinding(Cofactor cofactor) {
        List<Integer> evs;
        if (cofactor == null) {
            return null;
        }
        CofactorType xmlCofactor = this.objectFactory.createCofactorType();
        xmlCofactor.setName(cofactor.getName());
        DbReferenceType dbref = this.objectFactory.createDbReferenceType();
        dbref.setType(cofactor.getCofactorReference().getCofactorReferenceType().toDisplayName());
        dbref.setId(cofactor.getCofactorReference().getReferenceId());
        xmlCofactor.setDbReference(dbref);
        List<EvidenceId> evidenceIds = cofactor.getEvidenceIds();
        if (evidenceIds != null && !evidenceIds.isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
            xmlCofactor.getEvidence().addAll(evs);
        }
        return xmlCofactor;
    }
}

