/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CofactorType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CofactorHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CofactorCommentStructuredHandler
implements GenericHandler<CofactorCommentStructured, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidencedValueHandler evidencedValueHandler;
    private final GenericHandler<Cofactor, CofactorType> cofactorHandler;

    public CofactorCommentStructuredHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        this.cofactorHandler = new CofactorHandler(commentFactory, objectFactory, evidenceReferenceHandler);
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, evidenceReferenceHandler, true);
    }

    @Override
    public CofactorCommentStructured fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType xmlComment) {
        if (xmlComment == null) {
            return null;
        }
        CofactorCommentStructured comment = (CofactorCommentStructured)this.commentFactory.buildComment(CommentType.COFACTOR);
        if (xmlComment.getMolecule() != null) {
            comment.setMolecule(xmlComment.getMolecule().getValue());
        }
        if (!xmlComment.getText().isEmpty()) {
            CofactorNote note = this.commentFactory.buildCofactorNote();
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            for (EvidencedStringType evStr : xmlComment.getText()) {
                evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
            }
            note.setTexts(evValues);
            comment.setNote(note);
        }
        if (xmlComment.getCofactor() != null && !xmlComment.getCofactor().isEmpty()) {
            ArrayList<Cofactor> cofactors = new ArrayList<Cofactor>();
            for (CofactorType xmlCofactor : xmlComment.getCofactor()) {
                Cofactor cofactor = this.cofactorHandler.fromXmlBinding(xmlCofactor);
                if (cofactor == null) continue;
                cofactors.add(cofactor);
            }
            comment.setCofactors(cofactors);
        }
        return comment;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(CofactorCommentStructured comment) {
        if (comment == null) {
            return null;
        }
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType xmlComment = this.objectFactory.createCommentType();
        xmlComment.setType(comment.getCommentType().toDisplayName().toLowerCase());
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setValue(comment.getMolecule());
            xmlComment.setMolecule(mol);
        }
        if (comment.getNote() != null && !comment.getNote().getTexts().isEmpty()) {
            for (EvidencedValue evValue : comment.getNote().getTexts()) {
                EvidencedStringType textAbsorption = this.evidencedValueHandler.toXmlBinding(evValue);
                xmlComment.getText().add(textAbsorption);
            }
        }
        if (comment.getCofactors() != null && !comment.getCofactors().isEmpty()) {
            for (Cofactor cofactor : comment.getCofactors()) {
                CofactorType xmlCofactor = this.cofactorHandler.toXmlBinding(cofactor);
                if (xmlCofactor == null) continue;
                xmlComment.getCofactor().add(xmlCofactor);
            }
        }
        return xmlComment;
    }
}

