/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.xrefs;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.DOI;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.Constants;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefsStrategy;

public class DoiStrategy
implements CitationXrefsStrategy {
    private final GenericHandler<DOI, String> doiHandler;
    private final ObjectFactory objectFactory;

    public DoiStrategy(GenericHandler<DOI, String> doiHandler, ObjectFactory objectFactory) {
        this.doiHandler = doiHandler;
        this.objectFactory = objectFactory;
    }

    @Override
    public void fromJAXB(DbReferenceType referenceType, CitationXrefs citationXrefs) {
        if (referenceType.getType().equalsIgnoreCase(Constants.DOI_XMLTAG.getValue())) {
            citationXrefs.setDOI(this.doiHandler.fromXmlBinding(referenceType.getId()));
        }
    }

    @Override
    public DbReferenceType toJAXB(CitationXrefs xrefs) {
        DbReferenceType dbReferenceXML = this.objectFactory.createDbReferenceType();
        String id = this.doiHandler.toXmlBinding(xrefs.getDOI());
        if (id != null && id.length() > 0) {
            String name = Constants.DOI_XMLTAG.getValue();
            dbReferenceXML.setType(name);
            dbReferenceXML.setId(id);
            return dbReferenceXML;
        }
        return null;
    }
}

