/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class UnpublishedObservationsHandler
implements GenericHandler<UnpublishedObservations, ReferenceType> {
    private final CitationNewFactory citationFactory;
    private final ObjectFactory objectFactory;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public UnpublishedObservationsHandler(CitationNewFactory citationFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.citationFactory = citationFactory;
        this.objectFactory = objectFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
    }

    @Override
    public UnpublishedObservations fromXmlBinding(ReferenceType referenceXML) {
        UnpublishedObservations citation = this.citationFactory.buildUnpublishedObservations();
        this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
        return citation;
    }

    @Override
    public ReferenceType toXmlBinding(UnpublishedObservations citation) {
        ReferenceType referenceXML = this.objectFactory.createReferenceType();
        CitationType citationXML = this.objectFactory.createCitationType();
        referenceXML.setCitation(citationXML);
        citationXML.setType(citation.getCitationType().getDisplayName());
        this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
        return referenceXML;
    }
}

