/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Country;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Institute;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class ThesisHandler
implements GenericHandler<Thesis, ReferenceType> {
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final GenericHandler<City, String> cityHandler;
    private final GenericHandler<Institute, String> instituteHandler;
    private final GenericHandler<Country, String> countryHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public ThesisHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.citationFactory = citationFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.cityHandler = itemFactory.buildCityHandler();
        this.instituteHandler = itemFactory.buildInstituteHandler();
        this.countryHandler = itemFactory.buildCountryHandler();
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
    }

    @Override
    public Thesis fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            Country country;
            Institute institute;
            Thesis citation = this.citationFactory.buildThesis();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            City city = this.cityHandler.fromXmlBinding(citationXML.getCity());
            if (city != null) {
                citation.setCity(city);
            }
            if ((institute = this.instituteHandler.fromXmlBinding(citationXML.getInstitute())) != null) {
                citation.setInstitute(institute);
            }
            if ((country = this.countryHandler.fromXmlBinding(citationXML.getCountry())) != null) {
                citation.setCountry(country);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(Thesis citation) {
        if (citation == null) {
            return null;
        }
        ReferenceType referenceXML = this.objectFactory.createReferenceType();
        CitationType citationXML = this.objectFactory.createCitationType();
        referenceXML.setCitation(citationXML);
        citationXML.setType("thesis");
        citationXML.setCity(this.cityHandler.toXmlBinding(citation.getCity()));
        citationXML.setInstitute(this.instituteHandler.toXmlBinding(citation.getInstitute()));
        citationXML.setCountry(this.countryHandler.toXmlBinding(citation.getCountry()));
        this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
        return referenceXML;
    }
}

