/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Locator;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PublicationDate;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class ElectronicArticleHandler
implements GenericHandler<ElectronicArticle, ReferenceType> {
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final GenericHandler<Locator, String> locatorHandler;
    private final GenericHandler<JournalName, String> journalNameHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;
    private final GenericHandler<PublicationDate, String> publicationDateHandler;

    public ElectronicArticleHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.citationFactory = citationFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.locatorHandler = itemFactory.buildLocatorHandler();
        this.journalNameHandler = itemFactory.buildJournalNameHandler();
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
        this.publicationDateHandler = itemFactory.buildPublicationDateHandler();
    }

    @Override
    public ElectronicArticle fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            PublicationDate publicationDate;
            JournalName journalName;
            ElectronicArticle citation = this.citationFactory.buildElectronicArticle();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            Locator locator = this.locatorHandler.fromXmlBinding(citationXML.getLocator());
            if (locator != null) {
                citation.setLocator(locator);
            }
            if ((journalName = this.journalNameHandler.fromXmlBinding(citationXML.getName())) != null) {
                citation.setJournalName(journalName);
            }
            if ((publicationDate = this.publicationDateHandler.fromXmlBinding(citationXML.getDate())) != null) {
                citation.setPublicationDate(publicationDate);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(ElectronicArticle citation) {
        if (citation != null) {
            ReferenceType referenceXML = this.objectFactory.createReferenceType();
            CitationType citationXML = this.objectFactory.createCitationType();
            referenceXML.setCitation(citationXML);
            citationXML.setType("online journal article");
            citationXML.setName(this.journalNameHandler.toXmlBinding(citation.getJournalName()));
            citationXML.setLocator(this.locatorHandler.toXmlBinding(citation.getLocator()));
            citationXML.setDate(this.publicationDateHandler.toXmlBinding(citation.getPublicationDate()));
            this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
            if (referenceXML.getCitation().getTitle() != null) {
                return referenceXML;
            }
        }
        return null;
    }
}

