/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.math.BigInteger;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.util.AccessionResolver;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SourceType;

public class SourceProcessor {
    private static final String ATTRIBUTE_SEPARATOR = "=";
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("=");
    private final EvidenceFactory evidenceFactory;
    private final Map<EvidenceCode, EvidenceSourceHandler> HANDLE_CONVERSION = new EnumMap<EvidenceCode, EvidenceSourceHandler>(EvidenceCode.class);
    private ObjectFactory objectFactory;

    public SourceProcessor(EvidenceFactory evidenceFactory) {
        this.evidenceFactory = evidenceFactory;
        HandleCurationExperimentalOpinion handleCurExpOpAndLit = new HandleCurationExperimentalOpinion();
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000250, new HandleCurationSimilarity());
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000303, handleCurExpOpAndLit);
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000269, handleCurExpOpAndLit);
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000305, new HandleCurationJudgment());
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000313, new HandleImportsAndProgram());
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000312, new HandleCurationImport());
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000256, new HandleAutomatedAnnotation());
        this.HANDLE_CONVERSION.put(EvidenceCode.ECO_0000257, new HandleImportsAndProgram());
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void processToXML(Evidence entryEvidence, EvidenceType evidenceType) {
        EvidenceSourceHandler handler = this.HANDLE_CONVERSION.get((Object)entryEvidence.getEvidenceCode());
        if (handler == null) {
            throw new IllegalArgumentException("Unable to process the source for the given evidence code: " + evidenceType.getType());
        }
        handler.createXMLSource(entryEvidence, evidenceType);
    }

    public void processToUniProt(EvidenceType evidenceType, Evidence entryEvidence) {
        EvidenceSourceHandler handler = this.HANDLE_CONVERSION.get((Object)EvidenceCode.typeOf(evidenceType.getType()));
        if (handler == null) {
            throw new IllegalArgumentException("Unable to process the source for the given evidence code: " + evidenceType.getType());
        }
        handler.createUniProtSource(evidenceType, entryEvidence);
        if (evidenceType.getSource().getDbReference() != null) {
            DbReferenceType dbRef = evidenceType.getSource().getDbReference();
            entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.typeOf(dbRef.getType()));
        }
    }

    private class HandleAutomatedAnnotation
    extends EvidenceSourceSuper {
        private HandleAutomatedAnnotation() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            if (entryEvidence.getType() == uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.NOT_SPECIFIED) {
                throw new IllegalArgumentException("The data source of the evidence has not been specified: " + entryEvidence);
            }
            if (entryEvidence.getType() != uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.PROTIMP) {
                this.fillInData(entryEvidence.getType().getValue(), entryEvidence.getAttribute().getValue(), evidenceType);
            }
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            if (evidenceType != null && evidenceType.getSource() != null) {
                this.testDbReference(evidenceType);
                entryEvidence.setAttribute(this.buildEvidenceAttributeFromId(evidenceType));
                entryEvidence.setType(this.buildEvidenceType(evidenceType));
            } else {
                entryEvidence.setAttribute(SourceProcessor.this.evidenceFactory.buildEvidenceAttribute("-"));
                entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.PROTIMP);
            }
        }
    }

    private class HandleImportsAndProgram
    extends EvidenceSourceSuper {
        private HandleImportsAndProgram() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            if (entryEvidence.getType() == uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.NOT_SPECIFIED) {
                throw new IllegalArgumentException("The data source of the evidence has not been specified: " + entryEvidence);
            }
            this.fillInData(entryEvidence.getType().getValue(), entryEvidence.getAttribute().getValue(), evidenceType);
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            this.testEvidenceTypeAndSource(evidenceType);
            this.testDbReference(evidenceType);
            entryEvidence.setAttribute(this.buildEvidenceAttributeFromId(evidenceType));
            entryEvidence.setType(this.buildEvidenceType(evidenceType));
        }
    }

    private class HandleCurationJudgment
    extends EvidenceSourceSuper {
        private HandleCurationJudgment() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            if (!entryEvidence.getAttribute().getValue().trim().equals("-")) {
                this.populateXmlEvidenceTypeWithSource(entryEvidence, evidenceType);
            }
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            if (evidenceType.getSource() != null) {
                if (evidenceType.getSource().getDbReference() != null) {
                    entryEvidence.setAttribute(this.buildEvidenceAttributeFromTypeAndId(evidenceType));
                }
            } else {
                entryEvidence.setAttribute(SourceProcessor.this.evidenceFactory.buildEvidenceAttribute("-"));
            }
            entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.CURATOR);
        }
    }

    private class HandleCurationImport
    extends EvidenceSourceSuper {
        private HandleCurationImport() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            this.populateXmlEvidenceTypeWithSource(entryEvidence, evidenceType);
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            this.testEvidenceTypeAndSource(evidenceType);
            this.testDbReference(evidenceType);
            entryEvidence.setAttribute(this.buildEvidenceAttributeFromTypeAndId(evidenceType));
            entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.IMPORT);
        }
    }

    private class HandleCurationExperimentalOpinion
    extends EvidenceSourceSuper {
        private HandleCurationExperimentalOpinion() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            String[] spiltAttribute = ATTRIBUTE_PATTERN.split(entryEvidence.getAttribute().getValue());
            if (spiltAttribute[0].equalsIgnoreCase("reference")) {
                SourceType sourceType = SourceProcessor.this.objectFactory.createSourceType();
                sourceType.setRef(new BigInteger(spiltAttribute[1]));
                evidenceType.setSource(sourceType);
            } else {
                this.populateXmlEvidenceTypeWithSource(entryEvidence, evidenceType);
            }
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            this.testEvidenceTypeAndSource(evidenceType);
            if (evidenceType.getSource().getRef() != null) {
                entryEvidence.setAttribute(this.buildEvidenceAttributeFromRef(evidenceType));
            } else {
                this.testDbReference(evidenceType);
                entryEvidence.setAttribute(this.buildEvidenceAttributeFromTypeAndId(evidenceType));
            }
            EvidenceCode evidenceCode = EvidenceCode.typeOf(evidenceType.getType());
            if (evidenceCode == EvidenceCode.ECO_0000269) {
                entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.EXPERIMENTAL);
            } else if (evidenceCode == EvidenceCode.ECO_0000303) {
                entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.OPINION);
            }
        }
    }

    private class HandleCurationSimilarity
    extends EvidenceSourceSuper {
        private HandleCurationSimilarity() {
        }

        @Override
        public void createXMLSource(Evidence entryEvidence, EvidenceType evidenceType) {
            this.testEvidenceAttribute(entryEvidence);
            String identifier = entryEvidence.getAttribute().getValue().trim();
            if (identifier.endsWith("?")) {
                identifier = identifier.substring(0, identifier.length() - 1);
            }
            if (!AccessionResolver.isUniprotAccession(identifier)) {
                throw new IllegalArgumentException("The provided evidence does not contain a UniProt identifier:" + entryEvidence);
            }
            this.fillInData(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.UNIPROT.getValue(), entryEvidence.getAttribute().getValue(), evidenceType);
        }

        @Override
        public void createUniProtSource(EvidenceType evidenceType, Evidence entryEvidence) {
            this.testEvidenceTypeAndSource(evidenceType);
            this.testDbReference(evidenceType);
            String identifier = evidenceType.getSource().getDbReference().getId();
            if (identifier.endsWith("?")) {
                identifier = identifier.substring(0, identifier.length() - 1);
            }
            if (!AccessionResolver.isUniprotAccession(identifier)) {
                throw new IllegalArgumentException("The provided dbReferenceType does not contain a UniProt identifier:" + evidenceType.getKey() + ";" + evidenceType.getType() + ";" + evidenceType.getSource());
            }
            entryEvidence.setAttribute(SourceProcessor.this.evidenceFactory.buildEvidenceAttribute(evidenceType.getSource().getDbReference().getId()));
            entryEvidence.setType(uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.SIMILARITY);
        }
    }

    private abstract class EvidenceSourceSuper
    implements EvidenceSourceHandler {
        private EvidenceSourceSuper() {
        }

        void testEvidenceAttribute(Evidence entryEvidence) {
            EvidenceAttribute evAttribute = entryEvidence.getAttribute();
            if (evAttribute.getValue().trim().isEmpty()) {
                throw new IllegalArgumentException("The provided evidence does not contain a data source or identifier: " + entryEvidence);
            }
        }

        void testDbReference(EvidenceType evidenceType) {
            if (evidenceType.getSource().getDbReference() == null) {
                throw new IllegalArgumentException("The provided evidenceType does not contain a dbReferenceType: " + evidenceType.getKey() + ";" + evidenceType.getType() + ";" + evidenceType.getSource());
            }
        }

        void testEvidenceTypeAndSource(EvidenceType evidenceType) {
            if (evidenceType == null || evidenceType.getSource() == null) {
                throw new IllegalArgumentException("The provided evidenceType does not contain a SourceType: " + (evidenceType != null ? evidenceType.getKey() : null) + ";" + (evidenceType != null ? evidenceType.getType() : null) + ";" + (evidenceType != null ? evidenceType.getSource() : null));
            }
        }

        void fillInData(String type, String id, EvidenceType evidenceType) {
            DbReferenceType dbReference = SourceProcessor.this.objectFactory.createDbReferenceType();
            SourceType sourceType = SourceProcessor.this.objectFactory.createSourceType();
            sourceType.setDbReference(dbReference);
            dbReference.setType(type);
            dbReference.setId(id);
            evidenceType.setSource(sourceType);
        }

        void populateXmlEvidenceTypeWithSource(Evidence entryEvidence, EvidenceType evidenceType) {
            String[] spiltAttribute = ATTRIBUTE_PATTERN.split(entryEvidence.getAttribute().getValue());
            if (spiltAttribute[0].trim().isEmpty()) {
                throw new IllegalArgumentException("The provided evidence does not contain a source identifier: " + entryEvidence);
            }
            this.fillInData(spiltAttribute[0], spiltAttribute[1], evidenceType);
        }

        private String populateAttribute(EvidenceType evidenceType) {
            return evidenceType.getSource().getDbReference().getType() + SourceProcessor.ATTRIBUTE_SEPARATOR + evidenceType.getSource().getDbReference().getId();
        }

        EvidenceAttribute buildEvidenceAttributeFromTypeAndId(EvidenceType evidenceType) {
            return SourceProcessor.this.evidenceFactory.buildEvidenceAttribute(this.populateAttribute(evidenceType));
        }

        EvidenceAttribute buildEvidenceAttributeFromId(EvidenceType evidenceType) {
            return SourceProcessor.this.evidenceFactory.buildEvidenceAttribute(evidenceType.getSource().getDbReference().getId());
        }

        uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType buildEvidenceType(EvidenceType evidenceType) {
            return uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType.typeOf(evidenceType.getSource().getDbReference().getType());
        }

        EvidenceAttribute buildEvidenceAttributeFromRef(EvidenceType evidenceType) {
            return SourceProcessor.this.evidenceFactory.buildEvidenceAttribute("Reference=" + evidenceType.getSource().getRef().intValue());
        }
    }

    static interface EvidenceSourceHandler {
        public void createXMLSource(Evidence var1, EvidenceType var2);

        public void createUniProtSource(EvidenceType var1, Evidence var2);
    }
}

