/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.ebi.kraken.util.report.ExitCode;
import uk.ac.ebi.kraken.util.report.ProcessSummary;
import uk.ac.ebi.kraken.util.report.SummaryItem;

public class ProcessSummaryImpl
implements ProcessSummary {
    private String topic = "";
    private String source;
    private Map<SummaryItem, AtomicInteger> summaryData = new TreeMap<SummaryItem, AtomicInteger>();
    private List<String> comments = new ArrayList<String>();
    private Map<SummaryItem, Collection<String>> details = new TreeMap<SummaryItem, Collection<String>>();
    private boolean isFatal = false;
    private ExitCode exitCode = ExitCode.SUCCEEDED;

    public ProcessSummaryImpl(String topic) {
        this.topic = topic;
    }

    @Override
    public void add(SummaryItem item) {
        this.add(item, 1);
    }

    @Override
    public synchronized void add(SummaryItem item, int number) {
        AtomicInteger v = this.summaryData.get((Object)item);
        if (v != null) {
            v.addAndGet(number);
        } else {
            this.set(item, number);
        }
    }

    @Override
    public void reset() {
        this.summaryData.clear();
        this.comments.clear();
        this.details.clear();
    }

    @Override
    public synchronized void addItem(SummaryItem item, String id) {
        Collection<String> data = this.details.get((Object)item);
        if (data == null) {
            data = new ArrayList<String>();
            this.details.put(item, data);
        }
        data.add(id);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public synchronized void addComment(String comment) {
        this.comments.add(comment);
    }

    @Override
    public ExitCode getExitCode() {
        this.calculateExitCode();
        return this.exitCode;
    }

    private void calculateExitCode() {
        if (this.isFatal) {
            this.exitCode = ExitCode.FATAL;
            return;
        }
        ArrayList<SummaryItem> failed = new ArrayList<SummaryItem>();
        failed.add(SummaryItem.FAILED);
        failed.add(SummaryItem.NEED_RERUN);
        failed.add(SummaryItem.NEED_UPDATED);
        failed.add(SummaryItem.NEED_DELETED);
        for (SummaryItem item : failed) {
            Collection<String> failedItems = this.details.get((Object)item);
            AtomicInteger c = this.summaryData.get((Object)item);
            if ((c == null || c.get() <= 0) && (failedItems == null || failedItems.isEmpty())) continue;
            this.exitCode = ExitCode.FAILED;
            return;
        }
        this.exitCode = this.summaryData.containsKey((Object)SummaryItem.SKIPPED) || this.summaryData.containsKey((Object)SummaryItem.SUPPRESSED) || this.summaryData.containsKey((Object)SummaryItem.WARNED) ? ExitCode.WARNING : ExitCode.SUCCEEDED;
    }

    @Override
    public void setIsFatal() {
        this.isFatal = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.topic + " Process Summary\n");
        if (this.source != null) {
            sb.append("Data source:" + this.source + "\n");
        }
        sb.append("\n");
        for (Map.Entry<SummaryItem, AtomicInteger> entry : this.summaryData.entrySet()) {
            String key = entry.getKey().getName();
            AtomicInteger val = entry.getValue();
            sb.append(key).append(": ").append(val.get()).append("\n");
        }
        sb.append("***** ").append(this.getExitCode().toString()).append(" *****\n");
        return sb.toString();
    }

    @Override
    public String getDetailSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        for (Map.Entry<SummaryItem, Collection<String>> entry : this.details.entrySet()) {
            sb.append("\n");
            String key = entry.getKey().getName();
            sb.append(key).append(":\n");
            for (String s : entry.getValue()) {
                sb.append(s).append("\n");
            }
            sb.append(key).append(": Total: ").append(entry.getValue().size());
        }
        sb.append("\n");
        for (String s : this.comments) {
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public Map<SummaryItem, AtomicInteger> getSummaries() {
        return this.summaryData;
    }

    @Override
    public void set(SummaryItem type, int val) {
        AtomicInteger v = new AtomicInteger();
        v.set(val);
        this.summaryData.put(type, v);
    }

    @Override
    public int get(SummaryItem type) {
        AtomicInteger v = this.summaryData.get((Object)type);
        if (v == null) {
            return 0;
        }
        return v.get();
    }
}

