/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.objectcounter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ebi.kraken.util.objectcounter.CountedObject;

public class OldObjectCounter<T> {
    private Map<T, Integer> objectCounter = new HashMap<T, Integer>();

    public void add(T obj) {
        this.add(obj, 1);
    }

    public int getCount(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (!this.objectCounter.containsKey(obj)) {
            return 0;
        }
        return this.objectCounter.get(obj);
    }

    public void add(T obj, int num) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (this.objectCounter.containsKey(obj)) {
            int counter = this.objectCounter.get(obj);
            this.objectCounter.remove(obj);
            this.objectCounter.put(obj, counter + num);
        } else {
            this.objectCounter.put(obj, num);
        }
    }

    public void addAll(T[] tArray) {
        if (tArray == null) {
            throw new IllegalArgumentException();
        }
        for (T s : tArray) {
            this.add(s);
        }
    }

    public void addAll(Collection<T> input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        for (T s : input) {
            this.add(s);
        }
    }

    public void remove(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.objectCounter.remove(obj);
    }

    public void addAll(Map<T, Integer> map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.objectCounter.putAll(map);
    }

    public void addAll(OldObjectCounter<T> oc) {
        if (oc == null) {
            throw new IllegalArgumentException();
        }
        Map<T, Integer> map = oc.objectCounter;
        Set<T> set = map.keySet();
        for (T key : set) {
            if (this.objectCounter.containsKey(key)) {
                int thisvalue = this.objectCounter.get(key);
                int othervalue = oc.objectCounter.get(key);
                this.objectCounter.remove(key);
                this.objectCounter.put(key, thisvalue + othervalue);
                continue;
            }
            this.objectCounter.put(key, map.get(key));
        }
    }

    public Map<T, Integer> getData() {
        return this.objectCounter;
    }

    public boolean containsKey(T key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<T, Integer> map = this.getData();
        return map.containsKey(key);
    }

    public TreeSet<CountedObject<T>> getFirstObjects(int numberObjects) {
        TreeSet<CountedObject<T>> result = new TreeSet<CountedObject<T>>();
        Set<T> set = this.objectCounter.keySet();
        int iii = 0;
        for (T s : set) {
            if (++iii > numberObjects) break;
            int value = this.objectCounter.get(s);
            result.add(new CountedObject<T>(s, value, 1));
        }
        return result;
    }

    public String toString() {
        return this.getDescendingElements().toString();
    }

    public List<T> getObjectsWithFrequencyGreaterThan(int min) {
        ArrayList<T> result = new ArrayList<T>();
        List<CountedObject<T>> treeSet = this.getDescendingElements();
        for (CountedObject<T> t : treeSet) {
            if (t.getCount() > min) {
                result.add(t.getObject());
                continue;
            }
            return result;
        }
        return result;
    }

    public List<T> getObjectsWithFrequencyLowerThan(int max) {
        ArrayList<T> result = new ArrayList<T>();
        List<T> treeSet = this.getAscendingElements();
        for (T t : treeSet) {
            if (this.getCount(t) < max) {
                result.add(t);
                continue;
            }
            return result;
        }
        return result;
    }

    public List<T> getAscendingElements() {
        ArrayList result = new ArrayList();
        TreeSet<CountedObject<T>> sorted = new TreeSet<CountedObject<T>>();
        Set<T> keyset = this.objectCounter.keySet();
        for (T t : keyset) {
            sorted.add(new CountedObject<T>(t, this.getCount(t)));
        }
        for (CountedObject countedObject : sorted) {
            result.add(countedObject.getObject());
        }
        return result;
    }

    public List<CountedObject<T>> getDescendingElements() {
        ArrayList<CountedObject<T>> result = new ArrayList<CountedObject<T>>();
        TreeSet<CountedObject<T>> sorted = new TreeSet<CountedObject<T>>();
        Set<T> keyset = this.objectCounter.keySet();
        for (T t : keyset) {
            sorted.add(new CountedObject<T>(t, this.getCount(t), 1));
        }
        for (CountedObject countedObject : sorted) {
            result.add(countedObject);
        }
        return result;
    }

    public int getTotal() {
        int result = 0;
        for (Integer o : this.objectCounter.values()) {
            result += o.intValue();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OldObjectCounter that = (OldObjectCounter)o;
        if (that.getTotal() == 0 && this.getTotal() == 0) {
            return true;
        }
        return this.objectCounter.equals(that.objectCounter);
    }

    public int hashCode() {
        return this.objectCounter.hashCode();
    }
}

