/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.io.File;

public class FilesystemUtils {
    private FilesystemUtils() {
    }

    public static File assertDir(String dirPath) {
        File dir = new File(dirPath);
        return FilesystemUtils.assertDir(dir);
    }

    public static File assertDir(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(String.format("path '%s' cannot be found", dir));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' exists but is not a directory", dir));
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException(String.format("path '%s' cannot be read (lack of permissions?)", dir));
        }
        return dir;
    }

    public static File assertFile(String filePath) {
        File file = new File(filePath);
        return FilesystemUtils.assertFile(file);
    }

    public static File assertFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("path '%s' cannot be found", file));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("path '%s' exists but is not a normal file (a directory?)", file));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(String.format("path '%s' cannot be read (lack of permissions?)", file));
        }
        return file;
    }
}

