/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.unimes;

import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.unimes.UniMesEntry;
import uk.ac.ebi.kraken.model.factories.DefaultUniMesFactory;

public class FastaFileParser {
    public static UniMesEntry parse(String fastaFile) {
        DefaultUniMesFactory factory = DefaultUniMesFactory.getInstance();
        UniMesEntry entry = factory.buildEntry();
        StringTokenizer stToken = new StringTokenizer(fastaFile);
        String fitstToken = stToken.nextToken();
        entry.setUniMesAccession(factory.buildUniMesAccession(fitstToken.substring(1, fitstToken.indexOf(124))));
        entry.setPeptideId(factory.buildPeptideId(fitstToken.substring(fitstToken.indexOf(124) + 1)));
        StringBuilder sb = new StringBuilder();
        String st = "";
        boolean first = true;
        while (!st.equals("-")) {
            st = stToken.nextToken();
            if (st.equals("-")) continue;
            if (!first) {
                sb.append(" ");
            } else {
                first = false;
            }
            sb.append(st);
        }
        entry.setProteinDescription(factory.buildProteinDescription(sb.toString()));
        String rest = fastaFile.substring(fastaFile.indexOf(45) + 2);
        String organism = rest.substring(0, rest.indexOf(10));
        String sequence = rest.substring(rest.indexOf(10));
        sequence = sequence.replaceAll("\n", "");
        entry.setOrganism(factory.buildOrganism(organism));
        entry.setSequence(factory.buildSequence(sequence));
        return entry;
    }
}

