/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class WebResourceCommentTranslator
implements CommentTranslator<WebResourceComment> {
    private static final CommentType COMMENT_TYPE = CommentType.WEBRESOURCE;

    @Override
    public WebResourceComment translate(String annotation) {
        WebResourceComment comment = (WebResourceComment)DefaultCommentFactory.getInstance().buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    private String updateMolecule(String annotation, WebResourceComment comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    @Override
    public void translate(String annotation, WebResourceComment comment) {
        String[] tokens;
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ".");
        annotation = this.updateMolecule(annotation, comment);
        for (String token : tokens = annotation.split(";")) {
            if ((token = token.trim()).toLowerCase().startsWith("name")) {
                String name = token.substring(5, token.length());
                comment.setDatabaseName(DefaultUniProtFactory.getCommentFactory().buildDatabaseName(name));
                continue;
            }
            if (token.toLowerCase().startsWith("note")) {
                String note = token.substring(5, token.length());
                comment.setDatabaseNote(DefaultUniProtFactory.getCommentFactory().buildDatabaseNote(note));
                continue;
            }
            if (token.toLowerCase().startsWith("url")) {
                String www = token.substring(4, token.length());
                if (www.startsWith("\"")) {
                    www = www.substring(1, www.length());
                }
                if (www.endsWith("\"")) {
                    www = www.substring(0, www.length() - 1);
                }
                comment.setDatabaseURL(DefaultUniProtFactory.getCommentFactory().buildDatabaseURL(www));
                continue;
            }
            if (token.toLowerCase().startsWith("ftp")) {
                String ftp = token.substring(4, token.length());
                if (ftp.startsWith("\"")) {
                    ftp = ftp.substring(1, ftp.length());
                }
                if (ftp.endsWith("\"")) {
                    ftp = ftp.substring(0, ftp.length() - 1);
                }
                comment.setDatabaseFTP(DefaultUniProtFactory.getCommentFactory().buildDatabaseFTP(ftp));
                continue;
            }
            throw new RuntimeException(token);
        }
    }
}

