/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class SequenceCautionCommentTranslator
implements CommentTranslator<SequenceCautionComment> {
    private static final String SEQUENCE = "Sequence=";
    private static final String TYPE = "Type=";
    private static final String NOTE = "Note=";
    private static final String EVIDENCE = "Evidence=";
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.SEQUENCE_CAUTION;

    @Override
    public SequenceCautionComment translate(String annotation) {
        SequenceCautionComment comment = (SequenceCautionComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    private String updateMolecule(String annotation, SequenceCautionComment comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    @Override
    public void translate(String annotation, SequenceCautionComment comment) {
        String[] tokens;
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ";");
        annotation = this.updateMolecule(annotation, comment);
        for (String token : tokens = annotation.split(";")) {
            if ((token = token.trim()).startsWith(SEQUENCE)) {
                comment.setSequence(token.substring(SEQUENCE.length()));
                continue;
            }
            if (token.startsWith(TYPE)) {
                comment.setType(SequenceCautionType.typeOf(token.substring(TYPE.length())));
                continue;
            }
            if (token.startsWith(NOTE)) {
                comment.setNote(FACTORY.buildSequenceCautionCommentNote(token.substring(NOTE.length())));
                continue;
            }
            if (!token.startsWith(EVIDENCE)) continue;
            ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
            CommentTranslatorHelper.stripEvidenceIds(token.substring(EVIDENCE.length()), evidences);
            comment.setEvidenceIds(evidences);
        }
    }
}

