/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class InteractionCommentTranslator
implements CommentTranslator<InteractionComment> {
    private static final String INTERACT = "IntAct=";
    private static final CommentType COMMENT_TYPE = CommentType.INTERACTION;
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();

    @Override
    public InteractionComment translate(String annotation) {
        InteractionComment comment = (InteractionComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, InteractionComment comment) {
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        if ((annotation = CommentTranslatorHelper.stripTrailing(annotation, ".")) == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer st = new StringTokenizer(annotation, "\n");
        comment.getInteractions().clear();
        while (st.hasMoreTokens()) {
            String interactionString = st.nextToken();
            List<String> results = InteractionCommentTranslator.convertListInteraction(interactionString);
            for (String result : results) {
                Interaction interaction = this.convertInteraction(result);
                comment.getInteractions().add(interaction);
            }
        }
    }

    public static List<String> convertListInteraction(String interactionString) {
        int index;
        String str = interactionString.trim();
        ArrayList<String> interactions = new ArrayList<String>();
        do {
            int location;
            if ((location = str.indexOf(INTERACT)) == -1) {
                interactions.add(str);
                return interactions;
            }
            index = str.indexOf(";", location);
            String interaction = str.substring(0, index + 1);
            interactions.add(interaction);
        } while (index != str.length() - 1 && !(str = str.substring(index + 1).trim()).isEmpty());
        return interactions;
    }

    public Interaction convertInteraction(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Interaction interaction = FACTORY.buildInteraction();
        String[] tokens = value.split("; ");
        String first = tokens[0];
        String second = tokens[1];
        boolean xeno = false;
        int length = tokens.length;
        if (length == 5) {
            xeno = true;
        }
        String nbexp = tokens[length - 2];
        String intact = tokens[length - 1];
        interaction.setFirstInteractant(DefaultUniProtFactory.getCommentFactory().buildInteractorUniProtId(first));
        int index = second.indexOf(58);
        String acc = null;
        String genename = null;
        String parent = null;
        if (index != -1) {
            acc = second.substring(0, index);
            genename = second.substring(index + 1).trim();
        } else {
            acc = second;
        }
        index = acc.indexOf(91);
        if (index != -1) {
            parent = acc.substring(index + 1, acc.length() - 1);
            acc = acc.substring(0, index).trim();
        }
        if (xeno) {
            interaction.setInteractionType(InteractionType.XENO);
        } else {
            interaction.setInteractionType(InteractionType.BINARY);
        }
        interaction.setSecondInteractant(DefaultUniProtFactory.getCommentFactory().buildInteractorUniProtId(acc));
        if (parent != null) {
            interaction.setSecondInteractantParent(DefaultUniProtFactory.getCommentFactory().buildInteractorUniProtId(parent));
        }
        if (genename != null) {
            interaction.setInteractionGeneName(DefaultUniProtFactory.getCommentFactory().buildInteractionGeneName(genename));
        }
        interaction.setNumberOfExperiments(Integer.parseInt(nbexp.substring(6)));
        if (intact.endsWith(";")) {
            intact = intact.substring(0, intact.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(intact, "=, ");
        st.nextToken();
        String acc1 = st.nextToken();
        String acc2 = st.nextToken();
        interaction.setFirstInteractor(DefaultUniProtFactory.getCommentFactory().buildIntActAccession(acc1));
        interaction.setSecondInteractor(DefaultUniProtFactory.getCommentFactory().buildIntActAccession(acc2));
        return interaction;
    }
}

