/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import com.google.common.base.Strings;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasAlternativeSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.parser.FeatureHelper;
import uk.ac.ebi.kraken.parser.Translator;

public class FeatureTranslator
implements Translator<Feature> {
    private static final String FTID = "/id=\"";
    private static final String NOTE = "/note=\"";
    private static final String EVIDENCE = "/evidence=\"";
    private static final String SPACE = " ";
    private static final DefaultFeatureFactory FACTORY = DefaultFeatureFactory.getInstance();

    @Override
    public Feature translate(String annotation) {
        int index = annotation.indexOf(SPACE);
        String type = annotation.substring(0, index);
        annotation = annotation.substring(index + 1).trim();
        Feature feature = FeatureTranslator.createFeature(type);
        if (feature != null) {
            this.translate(annotation, feature);
        }
        return feature;
    }

    private Map.Entry<String, String> extractToken(String annotation, String tokenKey) {
        int index = annotation.indexOf(tokenKey);
        String token = "";
        if (index != -1) {
            token = annotation.substring(index + tokenKey.length());
            if (token.endsWith("\"")) {
                token = token.substring(0, token.length() - 1);
            }
            if ((annotation = annotation.substring(0, index).trim()).endsWith("\n")) {
                annotation.substring(0, annotation.length() - 1).trim();
            }
        }
        return new AbstractMap.SimpleEntry<String, String>(annotation, token);
    }

    @Override
    public void translate(String annotation, Feature feature) {
        if (annotation.startsWith(feature.getType().name())) {
            annotation = annotation.substring(feature.getType().name().length() + 1).trim();
        }
        Map.Entry<String, String> entry = this.extractToken(annotation, FTID);
        annotation = entry.getKey();
        String ftid = entry.getValue();
        if (!Strings.isNullOrEmpty((String)ftid) && feature instanceof HasFeatureId) {
            ((HasFeatureId)feature).setFeatureId(FACTORY.buildFeatureId(ftid));
        }
        entry = this.extractToken(annotation, EVIDENCE);
        annotation = entry.getKey();
        String evidence = entry.getValue();
        if (!Strings.isNullOrEmpty((String)evidence)) {
            String[] evIds = evidence.split(", ");
            feature.setEvidenceIds(Arrays.stream(evIds).map(evId -> DefaultEvidenceFactory.getInstance().buildEvidenceId(evId.trim())).collect(Collectors.toList()));
        }
        entry = this.extractToken(annotation, NOTE);
        annotation = entry.getKey();
        String note = entry.getValue();
        if (!Strings.isNullOrEmpty((String)note)) {
            String text = note.trim();
            FeatureTranslator.updateFeatureDescription(feature, text);
        }
        String sequence = "";
        String[] sToken = annotation.split(":");
        if (sToken.length == 2) {
            sequence = sToken[0];
            annotation = sToken[1];
        }
        String[] token = annotation.split("\\.\\.");
        String locationStart = token[0];
        String locationEnd = token[0];
        if (token.length == 2) {
            locationEnd = token[1];
        }
        feature.setFeatureLocation(FeatureTranslator.createFeatureLocation(locationStart, locationEnd, sequence));
    }

    public static Feature createFeature(String name) {
        for (FeatureType featureType : FeatureType.values()) {
            if (!name.equals(featureType.name())) continue;
            return FACTORY.buildFeature(featureType);
        }
        return null;
    }

    public static void updateFeatureDescription(Feature feature, String text) {
        if (feature instanceof ConflictFeature) {
            text = FeatureHelper.consumeConflictReport((ConflictFeature)feature, text);
        }
        if (feature instanceof HasFeatureDescription && !(feature instanceof ConflictFeature) && text != null && !text.isEmpty()) {
            ((HasFeatureDescription)feature).setFeatureDescription(FACTORY.buildFeatureDescription(text));
        }
        if (feature instanceof MutagenFeature) {
            text = FeatureHelper.consumeMutagenReport((MutagenFeature)feature, text);
        }
        if (feature instanceof VariantFeature) {
            text = FeatureHelper.consumeVariantReport((VariantFeature)feature, text);
        }
        if (feature instanceof VarSeqFeature) {
            text = FeatureHelper.consumeVarSplicFeature((VarSeqFeature)feature, text);
        }
        if (feature instanceof HasAlternativeSequence) {
            FeatureHelper.consumeAlternativeSequence((HasAlternativeSequence)feature, text);
        }
        if (feature instanceof CarbohydFeature) {
            if ((text = FeatureHelper.consumeCarbohydFeature((CarbohydFeature)feature, text)).equals(".")) {
                text = "";
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
            ((HasFeatureDescription)feature).setFeatureDescription(DefaultFeatureFactory.getInstance().buildFeatureDescription(text.trim()));
        }
    }

    public static FeatureLocation createFeatureLocation(String locationStart, String locationEnd, String sequence) {
        int value;
        String val;
        char c;
        FeatureLocation location = FACTORY.buildFeatureLocation();
        if (!Strings.isNullOrEmpty((String)sequence)) {
            location.setSequence(sequence);
        }
        if (locationStart == null) {
            location.setStartModifier(FeatureLocationModifier.UNKOWN);
        } else if (locationStart.trim().isEmpty()) {
            location.setStartModifier(FeatureLocationModifier.UNKOWN);
        } else {
            c = (locationStart = locationStart.trim()).charAt(0);
            if (c == '?') {
                if (locationStart.length() > 1) {
                    val = locationStart.substring(1).trim();
                    if (val.isEmpty()) {
                        location.setStartModifier(FeatureLocationModifier.UNKOWN);
                    } else {
                        value = Integer.parseInt(val);
                        if (value == -1) {
                            location.setStartModifier(FeatureLocationModifier.UNKOWN);
                        } else {
                            location.setStart(value);
                            location.setStartModifier(FeatureLocationModifier.UNSURE);
                        }
                    }
                } else {
                    location.setStartModifier(FeatureLocationModifier.UNKOWN);
                }
            } else if (c == '<') {
                location.setStartModifier(FeatureLocationModifier.OUTSIDE_KNOWN_SEQUENCE);
                if (locationStart.length() > 1) {
                    val = locationStart.substring(1);
                    location.setStart(Integer.parseInt(val.trim()));
                }
            } else {
                location.setStartModifier(FeatureLocationModifier.EXACT);
                location.setStart(Integer.parseInt(locationStart));
            }
        }
        if (locationEnd == null) {
            location.setEndModifier(FeatureLocationModifier.UNKOWN);
        } else if (locationEnd.trim().isEmpty()) {
            location.setEndModifier(FeatureLocationModifier.UNKOWN);
        } else {
            c = (locationEnd = locationEnd.trim()).charAt(0);
            if (c == '?') {
                location.setEndModifier(FeatureLocationModifier.UNSURE);
                if (locationEnd.length() > 1) {
                    val = locationEnd.substring(1);
                    value = Integer.parseInt(val);
                    if (value == -1) {
                        location.setEndModifier(FeatureLocationModifier.UNKOWN);
                    } else {
                        location.setEnd(value);
                        location.setEndModifier(FeatureLocationModifier.UNSURE);
                    }
                } else {
                    location.setEndModifier(FeatureLocationModifier.UNKOWN);
                }
            } else if (c == '>') {
                location.setEndModifier(FeatureLocationModifier.OUTSIDE_KNOWN_SEQUENCE);
                if (locationEnd.length() > 1) {
                    val = locationEnd.substring(1);
                    location.setEnd(Integer.parseInt(val.trim()));
                }
            } else {
                location.setEndModifier(FeatureLocationModifier.EXACT);
                location.setEnd(Integer.parseInt(locationEnd));
            }
        }
        return location;
    }
}

