/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.parser.FlatFileLoader;
import uk.ac.ebi.kraken.parser.LoaderException;
import uk.ac.ebi.kraken.parser.UniProtEntryIteratorException;
import uk.ac.ebi.kraken.parser.UniProtParser;
import uk.ac.ebi.kraken.parser.UniProtParserException;
import uk.ac.ebi.uniprot.parser.ParseException;

public class EntryIterator
implements Iterator<UniProtEntry>,
Iterable<UniProtEntry> {
    Logger logger = LoggerFactory.getLogger(EntryIterator.class);
    private UniProtFactory factory;
    private boolean getNext = true;
    private String original;
    private Map<String, Exception> exceptionBucket;
    private int maxEntriesInBucket = 1000;
    private FlatFileLoader loader;
    private boolean quiet = true;
    private boolean ignoreWrongDR = false;

    public EntryIterator(UniProtFactory factory, File file, boolean ignoreWrongDR) {
        this.ignoreWrongDR = ignoreWrongDR;
        try {
            BufferedReader in = null;
            in = file.getName().toLowerCase().endsWith(".gzip") || file.getName().toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))), 16384) : new BufferedReader(new InputStreamReader(new FileInputStream(file)), 16384);
            this.factory = factory;
            this.init(in);
        }
        catch (Exception e) {
            throw new UniProtEntryIteratorException(e);
        }
    }

    public EntryIterator(UniProtFactory factory, URL url, boolean ignoreWrongDR) {
        this.ignoreWrongDR = ignoreWrongDR;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.factory = factory;
            this.init(in);
        }
        catch (Exception e) {
            throw new UniProtEntryIteratorException(e);
        }
    }

    public EntryIterator(UniProtFactory factory, InputStream inputStream) {
        this(factory, inputStream, false);
    }

    public EntryIterator(UniProtFactory factory, InputStream inputStream, boolean ignoreWrongDR) {
        this.ignoreWrongDR = ignoreWrongDR;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            this.factory = factory;
            this.init(in);
        }
        catch (Exception e) {
            throw new UniProtEntryIteratorException(e);
        }
    }

    protected void init(Reader in) {
        this.loader = new FlatFileLoader(in);
        this.exceptionBucket = new HashMap<String, Exception>();
        this.getNext = true;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.getNext) {
                this.original = this.loader.getNextEntry();
                this.getNext = false;
            }
            if (this.original == null) {
                return false;
            }
        }
        catch (LoaderException e) {
            return false;
        }
        return true;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getFinalPart() {
        return this.loader.getCurrentPart();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UniProtEntry next() {
        UniProtEntry result = null;
        while (true) {
            this.loadOriginal();
            try {
                this.getNext = true;
                return UniProtParser.parse(this.original, this.factory, this.ignoreWrongDR);
            }
            catch (UniProtParserException e) {
                if (!this.quiet) throw new UniProtEntryIteratorException("Entry not parsable", e, this.original);
                this.logger.error(e.getMessage(), (Throwable)e);
                this.logger.error("******************** FAILED ENTRY ************************************");
                this.logger.error(this.original);
                this.logger.error("**********************************************************************");
                this.exceptionBucket.put(this.original, e);
                if (this.exceptionBucket.size() <= this.maxEntriesInBucket) continue;
                throw new UniProtEntryIteratorException("Unable to continue parsing the exception bucket now contains " + this.exceptionBucket.size() + " entries. Last failed entries was", e, this.original);
            }
            catch (ParseException e) {
                if (!this.quiet) throw new UniProtEntryIteratorException("Entry not parsable", e, this.original);
                this.logger.error(e.getDetailedMessage(), (Throwable)e);
                this.logger.error("******************** FAILED ENTRY ************************************");
                this.logger.error(this.original);
                this.logger.error("**********************************************************************");
                this.exceptionBucket.put(this.original, e);
                if (this.exceptionBucket.size() <= this.maxEntriesInBucket) continue;
                throw new UniProtEntryIteratorException("Unable to continue parsing the exception bucket now contains " + this.exceptionBucket.size() + " entries. Last failed entries was", e, this.original);
            }
            catch (RuntimeException ee) {
                this.logger.error(ee.getMessage());
                if (!this.quiet) continue;
                this.logger.error("******************** FAILED ENTRY ************************************");
                this.logger.error(this.original);
                this.logger.error("**********************************************************************");
                this.exceptionBucket.put(this.original, ee);
                if (this.exceptionBucket.size() > this.maxEntriesInBucket) throw new UniProtEntryIteratorException("Unable to continue parsing the exception bucket now contains " + this.exceptionBucket.size() + " entries. Last failed entries was", ee, this.original);
                continue;
            }
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadOriginal() {
        if (this.getNext) {
            this.original = this.loader.getNextEntry();
        }
        if (this.original == null) {
            throw new NoSuchElementException();
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Map<String, Exception> getExceptionBucket() {
        return this.exceptionBucket;
    }

    public void setExceptionBucket(Map<String, Exception> exceptionBucket) {
        this.exceptionBucket = exceptionBucket;
    }

    public int getMaxEntriesInBucket() {
        return this.maxEntriesInBucket;
    }

    public void setMaxEntriesInBucket(int maxEntriesInBucket) {
        this.maxEntriesInBucket = maxEntriesInBucket;
    }

    @Override
    public Iterator<UniProtEntry> iterator() {
        return this;
    }
}

