/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniref.member;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryId;
import uk.ac.ebi.kraken.interfaces.uniref.member.MemberId;
import uk.ac.ebi.kraken.interfaces.uniref.member.NCBITaxonomy;
import uk.ac.ebi.kraken.interfaces.uniref.member.OverlapRegion;
import uk.ac.ebi.kraken.interfaces.uniref.member.ProteinName;
import uk.ac.ebi.kraken.interfaces.uniref.member.SourceOrganism;
import uk.ac.ebi.kraken.interfaces.uniref.member.Type;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniParcAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class UniRefMemberImpl
implements UniRefMember {
    private Type type;
    private MemberId id;
    private UniParcAccession uniParcAccession;
    private ProteinName proteinName;
    private NCBITaxonomy ncbiTaxonomy;
    private SourceOrganism sourceOrganism;
    private int length;
    private OverlapRegion overlapRegion;
    private List<UniProtAccession> uniProtAccessions;
    private UniRefEntryId uniRef50;
    private UniRefEntryId uniRef90;
    private UniRefEntryId uniRef100;
    private boolean isSeed = false;

    public UniRefMemberImpl() {
        DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();
        this.type = factory.buildMemberType();
        this.id = factory.buildMemberId();
        this.uniParcAccession = factory.buildMemberUniParcAccession();
        this.proteinName = factory.buildMemberProteinName();
        this.ncbiTaxonomy = factory.buildMemberNCBITaxonomy();
        this.sourceOrganism = factory.buildMemberSourceOrganism();
        this.length = -1;
        this.overlapRegion = factory.buildMemberOverlapRegion();
        this.uniRef100 = factory.buildUniRefEntryId();
        this.uniRef90 = factory.buildUniRefEntryId();
        this.uniRef50 = factory.buildUniRefEntryId();
        this.uniProtAccessions = new NoNullElementsList<UniProtAccession>(new ArrayList());
    }

    @Override
    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Please set a non-null type");
        }
        this.type = type;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public Type getType() {
        return this.type;
    }

    @Override
    public void setMemberId(MemberId id) {
        if (id == null) {
            throw new IllegalArgumentException("Please set a non-null Membber Id");
        }
        this.id = id;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public MemberId getMemberId() {
        return this.id;
    }

    @IndexThisField(includeInContent=true)
    public MemberId getId() {
        return this.id;
    }

    @Override
    public void setUniProtAccessions(List<UniProtAccession> accessions) {
        if (accessions == null) {
            throw new IllegalArgumentException("Please set a non-null list of accessions");
        }
        this.uniProtAccessions = accessions;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIREF_MEMBER_ACCESSION}, includeInContent=true)
    public List<UniProtAccession> getUniProtAccessions() {
        return this.uniProtAccessions;
    }

    @Override
    public void setUniParcAccession(UniParcAccession accession) {
        if (accession == null) {
            throw new IllegalArgumentException("Please set a non-null uniparc accession");
        }
        this.uniParcAccession = accession;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIREF_MEMBER_ACCESSION}, includeInContent=true)
    public UniParcAccession getUniParcAccession() {
        return this.uniParcAccession;
    }

    @Override
    public void setProteinName(ProteinName proteinName) {
        if (proteinName == null) {
            throw new IllegalArgumentException("Please set a non-null protein name");
        }
        this.proteinName = proteinName;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public ProteinName getProteinName() {
        return this.proteinName;
    }

    @Override
    public void setNCBITaxonomy(NCBITaxonomy ncbiTaxonomy) {
        if (ncbiTaxonomy == null) {
            throw new IllegalArgumentException("Please set a non-null tax");
        }
        this.ncbiTaxonomy = ncbiTaxonomy;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public NCBITaxonomy getNCBITaxonomy() {
        return this.ncbiTaxonomy;
    }

    @Override
    public void setSourceOrganism(SourceOrganism sourceOrganism) {
        if (sourceOrganism == null) {
            throw new IllegalArgumentException("Please set a non-null source organism");
        }
        this.sourceOrganism = sourceOrganism;
    }

    @Override
    @IndexThisField(includeInContent=true)
    public SourceOrganism getSourceOrganism() {
        return this.sourceOrganism;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setOverlapRegion(OverlapRegion overlapRegion) {
        if (overlapRegion == null) {
            throw new IllegalArgumentException("Please set a non-null overlap region");
        }
        this.overlapRegion = overlapRegion;
    }

    @Override
    @IndexThisField
    public OverlapRegion getOverlapRegion() {
        return this.overlapRegion;
    }

    @Override
    public UniRefEntryId getUniRef100EntryId() {
        return this.uniRef100;
    }

    @Override
    public void setUniRef100EntryId(UniRefEntryId id) {
        if (id == null) {
            throw new IllegalArgumentException("Please set a non-null uniref100entryid");
        }
        this.uniRef100 = id;
    }

    @Override
    public UniRefEntryId getUniRef90EntryId() {
        return this.uniRef90;
    }

    @Override
    public void setUniRef90EntryId(UniRefEntryId id) {
        if (id == null) {
            throw new IllegalArgumentException("Please set a non-null unref90entryid");
        }
        this.uniRef90 = id;
    }

    @Override
    public UniRefEntryId getUniRef50EntryId() {
        return this.uniRef50;
    }

    @Override
    public void setUniRef50EntryId(UniRefEntryId id) {
        if (id == null) {
            throw new IllegalArgumentException("Please set a non-null uniref50entryid");
        }
        this.uniRef50 = id;
    }

    @Override
    public boolean isSeed() {
        return this.isSeed;
    }

    @Override
    public void setSeed(boolean seed) {
        this.isSeed = seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniRefMemberImpl that = (UniRefMemberImpl)o;
        if (this.isSeed != that.isSeed) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.ncbiTaxonomy != null ? !this.ncbiTaxonomy.equals(that.ncbiTaxonomy) : that.ncbiTaxonomy != null) {
            return false;
        }
        if (this.overlapRegion != null ? !this.overlapRegion.equals(that.overlapRegion) : that.overlapRegion != null) {
            return false;
        }
        if (this.proteinName != null ? !this.proteinName.equals(that.proteinName) : that.proteinName != null) {
            return false;
        }
        if (this.sourceOrganism != null ? !this.sourceOrganism.equals(that.sourceOrganism) : that.sourceOrganism != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.uniParcAccession != null ? !this.uniParcAccession.equals(that.uniParcAccession) : that.uniParcAccession != null) {
            return false;
        }
        if (this.uniProtAccessions != null ? !this.uniProtAccessions.equals(that.uniProtAccessions) : that.uniProtAccessions != null) {
            return false;
        }
        if (this.uniRef100 != null ? !this.uniRef100.equals(that.uniRef100) : that.uniRef100 != null) {
            return false;
        }
        if (this.uniRef50 != null ? !this.uniRef50.equals(that.uniRef50) : that.uniRef50 != null) {
            return false;
        }
        return !(this.uniRef90 != null ? !this.uniRef90.equals(that.uniRef90) : that.uniRef90 != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.uniParcAccession != null ? this.uniParcAccession.hashCode() : 0);
        result = 31 * result + (this.proteinName != null ? this.proteinName.hashCode() : 0);
        result = 31 * result + (this.ncbiTaxonomy != null ? this.ncbiTaxonomy.hashCode() : 0);
        result = 31 * result + (this.sourceOrganism != null ? this.sourceOrganism.hashCode() : 0);
        result = 31 * result + this.length;
        result = 31 * result + (this.overlapRegion != null ? this.overlapRegion.hashCode() : 0);
        result = 31 * result + (this.uniProtAccessions != null ? this.uniProtAccessions.hashCode() : 0);
        result = 31 * result + (this.uniRef50 != null ? this.uniRef50.hashCode() : 0);
        result = 31 * result + (this.uniRef90 != null ? this.uniRef90.hashCode() : 0);
        result = 31 * result + (this.uniRef100 != null ? this.uniRef100.hashCode() : 0);
        result = 31 * result + (this.isSeed ? 1 : 0);
        return result;
    }
}

