/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.util.CollectionOrderer;
import uk.ac.ebi.kraken.model.factories.DefaultUtilitiesFactory;

public class CompareObjects {
    static String difference = "";

    public static String compareEntries(UniProtEntry ent1, UniProtEntry ent2) {
        if (CompareObjects.compare(ent1, ent2)) {
            CompareObjects.addDifference("Both entries are identical");
        }
        return difference;
    }

    public static boolean compare(UniProtEntry ent1, UniProtEntry ent2) {
        HashSet<DatabaseCrossReference> r2;
        HashSet<Feature> f2;
        HashSet<Citation> cit2;
        HashSet<Comment> c2;
        if (ent1 == null) {
            CompareObjects.addDifference("The first entry is null");
            return false;
        }
        if (ent2 == null) {
            CompareObjects.addDifference("The second entry is null");
            return false;
        }
        if (ent1.getType() != ent2.getType()) {
            CompareObjects.addDifference("this.getType().getValue() = " + ent1.getType().getValue());
            CompareObjects.addDifference("ent2.getType().getValue() = " + ent2.getType().getValue());
            return false;
        }
        if (!ent1.getUniProtId().equals(ent2.getUniProtId())) {
            CompareObjects.addDifference("ent1.getUniProtId().getValue() = " + ent1.getUniProtId().getValue());
            CompareObjects.addDifference("ent2.getUniProtId().getValue() = " + ent2.getUniProtId().getValue());
            return false;
        }
        if (!ent1.getPrimaryUniProtAccession().equals(ent2.getPrimaryUniProtAccession())) {
            CompareObjects.addDifference("ent1.getPrimaryUniProtAccession().getValue() = " + ent1.getPrimaryUniProtAccession().getValue());
            CompareObjects.addDifference("ent2.getPrimaryUniProtAccession().getValue() = " + ent2.getPrimaryUniProtAccession().getValue());
            return false;
        }
        if (!ent1.getSecondaryUniProtAccessions().equals(ent2.getSecondaryUniProtAccessions())) {
            CompareObjects.addDifference("ent1.getSecondaryUniProtAccessions().size() = " + ent1.getSecondaryUniProtAccessions().size());
            CompareObjects.addDifference("ent2.getSecondaryUniProtAccessions().size() = " + ent2.getSecondaryUniProtAccessions().size());
            int i = 0;
            for (NcbiTaxonomyId ncbiTaxonomyId : ent1.getNcbiTaxonomyIds()) {
                CompareObjects.addDifference("ncbiTaxonomyId.getValue() = " + ncbiTaxonomyId.getValue());
                CompareObjects.addDifference("ent2.getSecondaryUniProtAccessions().get(i) = " + ent2.getSecondaryUniProtAccessions().get(i).getValue());
                ++i;
            }
            return false;
        }
        if (!ent1.getEntryAudit().equals(ent2.getEntryAudit())) {
            CompareObjects.addDifference("ent1.getEntryAudit().getCreationDate() = " + ent1.getEntryAudit().getCreationDate());
            CompareObjects.addDifference("ent2.getEntryAudit().getCreationDate() = " + ent2.getEntryAudit().getCreationDate());
            CompareObjects.addDifference("ent1.getEntryAudit().getLastAnnotationUpdateDate() = " + ent1.getEntryAudit().getLastAnnotationUpdateDate());
            CompareObjects.addDifference("ent2.getEntryAudit().getLastAnnotationUpdateDate() = " + ent2.getEntryAudit().getLastAnnotationUpdateDate());
            CompareObjects.addDifference("ent1.getEntryAudit().getEntryVersion() = " + ent1.getEntryAudit().getEntryVersion());
            CompareObjects.addDifference("ent2.getEntryAudit().getEntryVersion() = " + ent2.getEntryAudit().getEntryVersion());
            CompareObjects.addDifference("ent1.getEntryAudit().getLastSequenceUpdateDate() = " + ent1.getEntryAudit().getLastSequenceUpdateDate());
            CompareObjects.addDifference("ent2.getEntryAudit().getLastSequenceUpdateDate() = " + ent2.getEntryAudit().getLastSequenceUpdateDate());
            CompareObjects.addDifference("ent1.getEntryAudit().getSequenceVersion() = " + ent1.getEntryAudit().getSequenceVersion());
            CompareObjects.addDifference("ent2.getEntryAudit().getSequenceVersion() = " + ent2.getEntryAudit().getSequenceVersion());
        }
        if (!ent1.getTaxonomy().equals(ent2.getTaxonomy())) {
            CompareObjects.addDifference("Taxonomy Different");
            return false;
        }
        if (!ent1.getOrganelles().equals(ent2.getOrganelles())) {
            CompareObjects.addDifference("Organelles Different");
            return false;
        }
        HashSet<Comment> c1 = new HashSet<Comment>(ent1.getComments());
        if (!c1.equals(c2 = new HashSet<Comment>(ent2.getComments()))) {
            CompareObjects.addDifference("comments are different:\n");
            for (CommentType commentType : CommentType.values()) {
                List comments1 = ent1.getComments(commentType);
                List comments2 = ent2.getComments(commentType);
                if (comments1.size() != comments2.size()) {
                    CompareObjects.addDifference("there are " + comments1.size() + " " + commentType.toDisplayName() + " comments in entry1");
                    CompareObjects.addDifference("there are " + comments2.size() + " " + commentType.toDisplayName() + " comments in entry2");
                    return false;
                }
                int i = 0;
                for (Comment comment : comments1) {
                    if (!comment.equals(comments2.get(i))) {
                        if (!(comment instanceof TextOnlyComment)) {
                            CompareObjects.addDifference("comment1 " + (Object)((Object)comment.getCommentType()) + "\n");
                            CompareObjects.addDifference(comment.toString() + "\n");
                            CompareObjects.addDifference("comment2 " + (Object)((Object)((Comment)comments2.get(i)).getCommentType()) + "\n");
                            CompareObjects.addDifference(((Comment)comments2.get(i)).toString() + "\n");
                        } else {
                            TextOnlyComment textComment1 = (TextOnlyComment)comment;
                            TextOnlyComment textComment2 = (TextOnlyComment)comments2.get(i);
                            if (textComment1.getValue().replaceAll(" ", "").equals(textComment2.getValue().replaceAll(" ", ""))) {
                                CompareObjects.addDifference("**********************************\n");
                                CompareObjects.addDifference("Warning Ignore this error!!!!!!\n");
                                CompareObjects.addDifference("**********************************\n");
                            } else {
                                CompareObjects.addDifference("comment1 " + (Object)((Object)comment.getCommentType()) + "\n");
                                CompareObjects.addDifference(comment.toString() + "\n");
                                CompareObjects.addDifference("comment2 " + (Object)((Object)((Comment)comments2.get(i)).getCommentType()) + "\n");
                                CompareObjects.addDifference(((Comment)comments2.get(i)).toString() + "\n");
                            }
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
        HashSet<Citation> cit1 = new HashSet<Citation>(ent1.getCitationsNew());
        if (!cit1.equals(cit2 = new HashSet<Citation>(ent2.getCitationsNew()))) {
            CompareObjects.addDifference("Citations are different\n");
            int i = 0;
            boolean parsingSubmission = false;
            if (cit1.size() != cit2.size()) {
                CompareObjects.addDifference("there are " + cit1.size() + " Citations in entry1");
                CompareObjects.addDifference("there are " + cit2.size() + " Citations in entry2");
                return false;
            }
            for (Citation citation : ent1.getCitationsNew()) {
                if (!citation.equals(ent2.getCitationsNew().get(i))) {
                    Submission submission;
                    CompareObjects.addDifference(citation.getCitationType().getValue() + "\n");
                    if (ent2.getCitationsNew().get(i).getCitationType() == CitationTypeEnum.SUBMISSION && (submission = (Submission)ent2.getCitationsNew().get(i)).getSubmittedToDatabase() == SubmissionDatabase.UNKNOWN) {
                        parsingSubmission = true;
                    }
                    CompareObjects.addDifference("--------citation1----------\n");
                    CompareObjects.addDifference(citation.toString() + "\n");
                    CompareObjects.addDifference("--------citation2----------\n");
                    CompareObjects.addDifference(ent2.getCitationsNew().get(i).toString() + "\n");
                }
                ++i;
            }
            if (parsingSubmission) {
                CompareObjects.addDifference("**********************************\n");
                CompareObjects.addDifference("Warning Ignore this error!!!!!!\n");
                CompareObjects.addDifference("**********************************\n");
            }
            return false;
        }
        HashSet<Feature> f1 = new HashSet<Feature>(ent1.getFeatures());
        if (!f1.equals(f2 = new HashSet<Feature>(ent2.getFeatures()))) {
            CompareObjects.addDifference("Features are different");
            DefaultUtilitiesFactory utilitiesFactory = DefaultUtilitiesFactory.getInstance();
            for (FeatureType featureType : FeatureType.values()) {
                Collection featuresColl1 = ent1.getFeatures(featureType);
                Collection featuresColl2 = ent2.getFeatures(featureType);
                if (featuresColl1.size() != featuresColl2.size()) {
                    CompareObjects.addDifference("there are " + featuresColl1.size() + " " + featureType.getValue() + " Features  in entry1");
                    CompareObjects.addDifference("there are " + featuresColl2.size() + " " + featureType.getValue() + " Features  in entry2");
                    return false;
                }
                CollectionOrderer collectionOrderer = utilitiesFactory.buildCollectionOrderer(featuresColl1);
                List features1 = collectionOrderer.getListOrdered();
                collectionOrderer = utilitiesFactory.buildCollectionOrderer(featuresColl2);
                List features2 = collectionOrderer.getListOrdered();
                int i = 0;
                for (Feature feature : features1) {
                    CompareObjects.addDifference("feature1 \n" + feature.toString() + "\n");
                    CompareObjects.addDifference("feature2 \n" + ((Feature)features2.get(i)).toString() + "\n");
                    ++i;
                }
            }
            return false;
        }
        if (!ent1.getKeywords().equals(ent2.getKeywords())) {
            int i = 0;
            for (Keyword keyword : ent1.getKeywords()) {
                CompareObjects.addDifference("keyword1 = " + keyword.getValue());
                CompareObjects.addDifference("keyword2 = " + ent2.getKeywords().get(i).getValue());
                ++i;
            }
            return false;
        }
        if (!ent1.getSequence().equals(ent2.getSequence())) {
            CompareObjects.addDifference("ent1.sequence.toString() = " + ent1.getSequence().toString());
            CompareObjects.addDifference("ent2.sequence.toString() = " + ent2.getSequence().toString());
            return false;
        }
        if (!ent1.getNcbiTaxonomyIds().equals(ent2.getNcbiTaxonomyIds())) {
            int i = 0;
            for (NcbiTaxonomyId ncbiTaxonomyId : ent1.getNcbiTaxonomyIds()) {
                CompareObjects.addDifference("ncbiTaxonomyId.getValue() = " + ncbiTaxonomyId.getValue());
                CompareObjects.addDifference("ncbiTaxonomyId.getValue() = " + ent2.getNcbiTaxonomyIds().get(i).getValue());
                ++i;
            }
            return false;
        }
        HashSet<DatabaseCrossReference> r1 = new HashSet<DatabaseCrossReference>(ent1.getDatabaseCrossReferences());
        if (!r1.equals(r2 = new HashSet<DatabaseCrossReference>(ent2.getDatabaseCrossReferences()))) {
            CompareObjects.addDifference("DatatbaseCrossRef different");
            return false;
        }
        return true;
    }

    private static void addDifference(String newDiference) {
        difference = difference + newDiference + "\n";
    }
}

