/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.interpro;

public enum MethodType {
    GENE3D("GENE3D", "X"),
    MOBIDB_LITE("MOBIDBLT", "g"),
    PANTHER("PANTHER", "V"),
    PFAM("PFAM", "H"),
    PRINTS("PRINTS", "F"),
    PIR("PIR", "PIR"),
    PIRSF("PIRSF", "U"),
    PREFILE("PREFILE", ""),
    PRODOM("PRODOM", "D"),
    PROFILE("PROFILE", "M"),
    PROSITE("PROSITE", "P"),
    SMART("SMART", "R"),
    SSF("SSF", "Y"),
    TIGRFAMs("TIGRFAMs", "N"),
    HAMAP("HAMAP", "Q"),
    CDD("CDD", "J"),
    SFLD("SFLD", "B"),
    UNKNOWN("UNKNOWN", "na");

    private String value;
    private String dbcode;

    private MethodType(String type, String dbCode) {
        this.value = type;
        this.dbcode = dbCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getDbcode() {
        return this.dbcode;
    }

    public static MethodType typeOfDbCode(String dbcode) {
        for (MethodType type : MethodType.values()) {
            if (!type.getDbcode().equals(dbcode)) continue;
            return type;
        }
        throw new IllegalArgumentException("the MethodType with the dbcode " + dbcode + " doesn't exist");
    }

    public static MethodType typeOf(String value) {
        for (MethodType type : MethodType.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("the MethodType with the description " + value + " doesn't exist");
    }
}

