/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.LineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLine;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSourceType;

public class RCLineBuilder
implements RLine<List<SampleSource>> {
    private static final String LINE_PREFIX = (Object)((Object)LineType.RC) + "   ";
    private static SampleSourceType[] order = new SampleSourceType[]{SampleSourceType.STRAIN, SampleSourceType.PLASMID, SampleSourceType.TRANSPOSON, SampleSourceType.TISSUE};

    @Override
    public List<String> buildLine(List<SampleSource> f, boolean includeFFMarkup, boolean showEvidence) {
        if (!includeFFMarkup) {
            return this.buildLineStr(f);
        }
        if (f.isEmpty()) {
            return new ArrayList<String>();
        }
        LineBuilder lineBuilder = new LineBuilder(LINE_PREFIX, LineType.RC);
        ArrayList<StringBuilder> typeBuilders = new ArrayList<StringBuilder>();
        boolean first = true;
        for (SampleSourceType stype : order) {
            List<SampleSource> sampleSources = this.getSampleSources(f, stype);
            if (sampleSources.isEmpty()) continue;
            int counter = 0;
            first = true;
            StringBuilder typeBuilder = new StringBuilder();
            for (SampleSource sampleSource : sampleSources) {
                StringBuilder item = new StringBuilder();
                String separator = first ? " " : (sampleSources.size() == ++counter ? ", and " : ", ");
                if (first) {
                    item.append(stype.toString());
                    item.append("=");
                    first = false;
                }
                item.append(sampleSource.getValue());
                if (showEvidence) {
                    item.append(EvidenceLine.export(sampleSource.getEvidenceIds()));
                }
                if (typeBuilder.length() != 0) {
                    typeBuilder.append(separator);
                }
                typeBuilder.append((CharSequence)item);
            }
            if (typeBuilder.length() != 0) {
                typeBuilder.append(";");
            }
            typeBuilders.add(typeBuilder);
        }
        for (StringBuilder typeBuilder : typeBuilders) {
            lineBuilder.addItem(typeBuilder.toString(), " ");
        }
        lineBuilder.finish("");
        return lineBuilder.getLines();
    }

    private List<String> buildLineStr(List<SampleSource> f) {
        if (f.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<StringBuilder> typeBuilders = new ArrayList<StringBuilder>();
        boolean first = true;
        for (SampleSourceType stype : order) {
            List<SampleSource> sampleSources = this.getSampleSources(f, stype);
            if (sampleSources.isEmpty()) continue;
            int counter = 0;
            first = true;
            StringBuilder typeBuilder = new StringBuilder();
            for (SampleSource sampleSource : sampleSources) {
                StringBuilder item = new StringBuilder();
                String separator = first ? " " : (sampleSources.size() == ++counter ? ", and " : ", ");
                if (first) {
                    item.append(stype.toString());
                    item.append("=");
                    first = false;
                }
                item.append(sampleSource.getValue());
                if (typeBuilder.length() != 0) {
                    typeBuilder.append(separator);
                }
                typeBuilder.append((CharSequence)item);
            }
            if (typeBuilder.length() != 0) {
                typeBuilder.append(";");
            }
            typeBuilders.add(typeBuilder);
        }
        StringBuilder lineBuilder = new StringBuilder();
        int count = 0;
        for (StringBuilder typeBuilder : typeBuilders) {
            if (count > 0) {
                lineBuilder.append(" ");
            }
            lineBuilder.append(typeBuilder.toString());
            ++count;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(lineBuilder.toString());
        return lines;
    }

    private List<SampleSource> getSampleSources(List<SampleSource> sss, SampleSourceType stype) {
        ArrayList<SampleSource> sampleSources = new ArrayList<SampleSource>();
        for (SampleSource ss : sss) {
            if (stype != ss.getType()) continue;
            sampleSources.add(ss);
        }
        return sampleSources;
    }
}

