/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.ft.FTLineBuilderHelper;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;

public class SimpleFeatureLineBuilder<T extends Feature>
extends FFLineBuilderAbstr<T>
implements FFLineBuilder<T> {
    public SimpleFeatureLineBuilder() {
        super(LineType.FT);
    }

    @Override
    public String buildString(T f) {
        List<String> lines = this.buildLines(f, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(T f) {
        List<String> lines = this.buildLines(f, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(T f, boolean showEvidence) {
        List<String> lines = this.buildLines(f, true, showEvidence);
        return FFLines.create(lines);
    }

    protected List<String> buildLines(T f, boolean includeFFMarkings, boolean addEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(this.buildFtHeaderLines(f, includeFFMarkings));
        lines.addAll(this.buildFtNoteLines(f, includeFFMarkings));
        if (addEvidence) {
            lines.addAll(this.buildFtEvidenceLines(f, includeFFMarkings));
        }
        lines.addAll(this.buildFtIdLines(f, includeFFMarkings));
        return lines;
    }

    protected List<String> buildFtHeaderLines(T f, boolean includeFFMarkings) {
        StringBuilder sb = FTLineBuilderHelper.buildFeatureHeader(f, includeFFMarkings);
        ArrayList<String> lists = new ArrayList<String>();
        lists.add(sb.toString());
        return lists;
    }

    protected List<String> buildFtNoteLines(T f, boolean includeFFMarkings) {
        return FTLineBuilderHelper.buildNote(f, this.buildNoteString(f), includeFFMarkings);
    }

    protected List<String> buildFtEvidenceLines(T f, boolean includeFFMarkings) {
        StringBuilder sb = FTLineBuilderHelper.buildEvidences(f.getEvidenceIds(), includeFFMarkings);
        if (sb.length() == 0) {
            return Collections.emptyList();
        }
        String[] seps = new String[]{" ", "-"};
        if (includeFFMarkings) {
            return FFLineWrapper.buildLines(sb.toString(), seps, "FT                   ", 80);
        }
        ArrayList<String> lists = new ArrayList<String>();
        lists.add(sb.toString());
        return lists;
    }

    protected List<String> buildFtIdLines(T f, boolean includeFFMarkings) {
        if (f instanceof HasFeatureId) {
            StringBuilder featureId = FTLineBuilderHelper.buildFeatureId(((HasFeatureId)f).getFeatureId(), includeFFMarkings);
            if (featureId.length() > 0) {
                ArrayList<String> lists = new ArrayList<String>();
                lists.add(featureId.toString());
                return lists;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected StringBuilder buildNoteString(T f) {
        return FTLineBuilderHelper.buildExtra(f);
    }
}

