/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;

public class SequenceCautionCCLineBuilder
extends CCLineBuilderAbstr<SequenceCautionComment> {
    private boolean isFirstSequenceCauction = true;

    public void setIsFirstSequenceCaution(boolean isFirstSequenceCauction) {
        this.isFirstSequenceCauction = isFirstSequenceCauction;
    }

    @Override
    protected List<String> buildCommentLines(SequenceCautionComment comment, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        if (this.isFirstSequenceCauction) {
            lines.add(this.buildStartWithMolecule(comment, includeFFMarkings));
        }
        if (includeFFMarkings) {
            sb.append(this.linePrefix);
        }
        boolean needSpace = false;
        if (comment.getSequence() != null && !comment.getSequence().isEmpty()) {
            sb.append("Sequence=").append(comment.getSequence()).append(";");
            needSpace = true;
        }
        if (comment.getType() != null) {
            if (needSpace) {
                sb.append(" ");
            }
            sb.append("Type=").append(comment.getType().toDisplayName()).append(";");
            needSpace = true;
        }
        if (comment.getNote() != null && !comment.getNote().getValue().isEmpty()) {
            if (needSpace) {
                sb.append(" ");
            }
            sb.append("Note=");
            sb.append(comment.getNote().getValue());
            sb.append(";");
        }
        if (showEvidence && !comment.getEvidenceIds().isEmpty()) {
            sb.append(" ");
            sb.append("Evidence=");
            String evStr = EvidenceLine.export(comment.getEvidenceIds()).trim();
            sb.append(evStr).append(";");
        }
        lines.add(sb.toString());
        return lines;
    }
}

