/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;

public class CatalyticActivityCCLineBuilder
extends CCLineBuilderAbstr<CatalyticActivityCommentStructured> {
    private static final String EVIDENCE = "Evidence=";
    private static final String XREF = "Xref=";
    private static final String EC = "EC=";
    private static final String PHYSIO_DIRECTION = "PhysiologicalDirection=";
    private static final String REACTION = "Reaction=";

    private String convertReactionReference(ReactionReference rs) {
        StringBuilder sb = new StringBuilder();
        sb.append(rs.getType().toDisplayName()).append(":").append(rs.getId());
        return sb.toString();
    }

    @Override
    protected List<String> buildCommentLines(CatalyticActivityCommentStructured comment, boolean includeFFMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder firstLine = new StringBuilder();
        firstLine.append(this.buildStartWithMolecule(comment, includeFFMarkings));
        if (firstLine.length() > 0) {
            lines.add(firstLine.toString());
        }
        Reaction reaction = comment.getReaction();
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            sb.append(this.linePrefix);
        }
        sb.append(REACTION).append(reaction.getName()).append(";");
        List<ReactionReference> xrefs = reaction.getReactionReferences();
        if (!xrefs.isEmpty()) {
            sb.append(" ").append(XREF).append(xrefs.stream().map(this::convertReactionReference).collect(Collectors.joining(", "))).append(";");
        }
        if (!Strings.isNullOrEmpty((String)reaction.getECNumber())) {
            sb.append(" ").append(EC).append(reaction.getECNumber()).append(";");
        }
        if (!reaction.getEvidenceIds().isEmpty() && showEvidence) {
            sb.append(" ");
            sb.append(EVIDENCE);
            String evStr = EvidenceLine.export(reaction.getEvidenceIds()).trim();
            sb.append(evStr).append(";");
        }
        if (includeFFMarkings) {
            List<String> lls = FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, "CC         ", 80);
            lines.addAll(lls);
        } else {
            lines.add(sb.toString());
        }
        for (PhysiologicalReaction direction : comment.getPhysiologicalReactions()) {
            StringBuilder sb2 = new StringBuilder();
            if (includeFFMarkings) {
                sb2.append(this.linePrefix);
            }
            sb2.append(PHYSIO_DIRECTION).append(direction.getDirectionType().toDisplayName()).append("; ");
            sb2.append(XREF).append(this.convertReactionReference(direction.getReactionReference())).append(";");
            if (!direction.getEvidenceIds().isEmpty() && showEvidence) {
                sb2.append(" ");
                sb2.append(EVIDENCE);
                String evStr = EvidenceLine.export(direction.getEvidenceIds()).trim();
                sb2.append(evStr).append(";");
            }
            if (includeFFMarkings) {
                List<String> lls = FFLineWrapper.buildLines(sb2.toString(), LineConstant.SEPS, "CC         ", 80);
                lines.addAll(lls);
                continue;
            }
            lines.add(sb2.toString());
        }
        return lines;
    }
}

