/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.HasFreeText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;

public abstract class CCLineBuilderAbstr<T extends Comment>
extends FFLineBuilderAbstr<T>
implements FFLineBuilder<T> {
    private static final String CC_FF_MARK = "CC   -!- ";
    public static final String COMMENT_SPACE_INDENT = "         ";
    public static final String COMMENT_SPACE = "       ";
    public static final String CC_PREFIX_INDENT = "CC         ";
    protected static final String NOTE = "Note=";
    protected static final String NAME = "Name=";
    protected static final String BRACKET_RIGHT = ")";
    protected static final String BCACKET_LEFT = " (";

    public CCLineBuilderAbstr() {
        super(LineType.CC, COMMENT_SPACE);
    }

    protected abstract List<String> buildCommentLines(T var1, boolean var2, boolean var3);

    @Override
    public String buildString(T f) {
        List<String> lls = this.buildCommentLines(f, false, false);
        return FFLines.create(lls).toString();
    }

    @Override
    public String buildStringWithEvidence(T f) {
        List<String> lls = this.buildCommentLines(f, false, true);
        return FFLines.create(lls).toString();
    }

    @Override
    protected FFLine buildLine(T f, boolean showEvidence) {
        List<String> lls = this.buildCommentLines(f, true, showEvidence);
        return FFLines.create(lls);
    }

    protected String buildCommentStatus(HasCommentStatus comment) {
        String extra = "";
        if (comment.getCommentStatus() == CommentStatus.BY_SIMILARITY) {
            extra = extra + " (By similarity)";
        } else if (comment.getCommentStatus() == CommentStatus.PROBABLE) {
            extra = extra + " (Probable)";
        } else if (comment.getCommentStatus() == CommentStatus.POTENTIAL) {
            extra = extra + " (Potential)";
        }
        return extra;
    }

    protected StringBuilder addFlatFileMarkingsIfRequired(boolean includeFlatFileMarkings, StringBuilder sb) {
        if (includeFlatFileMarkings) {
            sb.append(CC_FF_MARK);
        }
        return sb;
    }

    protected StringBuilder addCommentTypeName(Comment comment, StringBuilder sb) {
        sb.append(comment.getCommentType().toDisplayName());
        sb.append(": ");
        return sb;
    }

    protected String buildStartWithMolecule(Comment comment, boolean includeFlatFileMarkings) {
        StringBuilder start = new StringBuilder();
        this.addFlatFileMarkingsIfRequired(includeFlatFileMarkings, start);
        start.append(comment.getCommentType().toDisplayName());
        start.append(":");
        String mol = comment.getMolecule();
        if (!Strings.isNullOrEmpty((String)mol)) {
            start.append(" ").append("[").append(mol).append("]").append(":");
        }
        return start.toString();
    }

    protected void addMolecule(Comment comment, StringBuilder sb, boolean appendSpace) {
        String mol = comment.getMolecule();
        if (!Strings.isNullOrEmpty((String)mol)) {
            sb.append("[").append(mol).append("]").append(":");
            if (appendSpace) {
                sb.append(" ");
            }
        }
    }

    protected StringBuilder addEvidence(HasEvidences he, StringBuilder str, boolean showEvidence, String postfix) {
        if (!showEvidence) {
            return str;
        }
        String evStr = EvidenceLine.export(he.getEvidenceIds());
        if (evStr.length() > 0) {
            str.append(evStr);
            str.append(postfix);
        }
        return str;
    }

    protected StringBuilder addEvidence(HasEvidences he, StringBuilder str, boolean showEvidence, String postfix, String postfixWitNoEvidence) {
        if (!showEvidence) {
            str.append(postfixWitNoEvidence);
            return str;
        }
        String evStr = EvidenceLine.export(he.getEvidenceIds());
        if (evStr.length() > 0) {
            str.append(evStr);
            str.append(postfix);
        } else {
            str.append(postfixWitNoEvidence);
        }
        return str;
    }

    protected List<String> addEvidences(List<String> lines, HasEvidences he, boolean showEvidence, String linePref) {
        if (showEvidence && !he.getEvidenceIds().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> lines2 = new ArrayList<String>();
            for (int i = 0; i < lines.size(); ++i) {
                if (i == lines.size() - 1) {
                    sb.append(lines.get(i));
                    continue;
                }
                lines2.add(lines.get(i));
            }
            sb = this.addEvidences(sb, he, showEvidence);
            List<String> lls = FFLineWrapper.buildLines(sb, " ", linePref);
            lines2.addAll(lls);
            return lines2;
        }
        return lines;
    }

    protected String buildFreeText(HasFreeText depend, boolean showEvidence, String separator, String end) {
        boolean isfirst = true;
        StringBuilder sb = new StringBuilder();
        for (EvidencedValue val : depend.getTexts()) {
            if (!isfirst) {
                sb.append(separator);
                sb.append(" ");
            }
            sb.append(val.getValue());
            this.appendIfNot(sb, ".");
            if (showEvidence) {
                sb.append(EvidenceLine.export(val.getEvidenceIds()));
            }
            isfirst = false;
        }
        sb.append(end);
        return sb.toString();
    }
}

