/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CommentLineBuilderFactory;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.SequenceCautionCCLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;

public class CCLineBuilder
extends FFLineBuilderAbstr<List<Comment>>
implements FFLineBuilder<List<Comment>> {
    public CCLineBuilder() {
        super(LineType.CC);
    }

    @Override
    public String buildString(List<Comment> f) {
        List<String> lines = this.buildLines(f, false, false);
        return FFLines.create(lines).toString();
    }

    @Override
    public String buildStringWithEvidence(List<Comment> f) {
        List<String> lines = this.buildLines(f, false, true);
        return FFLines.create(lines).toString();
    }

    @Override
    protected FFLine buildLine(List<Comment> f, boolean showEvidence) {
        List<String> lines = this.buildLines(f, true, showEvidence);
        return FFLines.create(lines);
    }

    private List<String> buildLines(List<Comment> f, boolean includeFFMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        int nSeqCaution = 0;
        for (Comment comment : f) {
            FFLineBuilder<Comment> fbuilder = CommentLineBuilderFactory.create(comment);
            if (comment.getCommentType() == CommentType.SEQUENCE_CAUTION) {
                FFLineBuilder<SequenceCautionComment> seqCautionBuilder = CommentLineBuilderFactory.create((SequenceCautionComment)comment);
                ((SequenceCautionCCLineBuilder)seqCautionBuilder).setIsFirstSequenceCaution(++nSeqCaution == 1);
            }
            if (includeFFMarkings) {
                if (showEvidence) {
                    lines.addAll(fbuilder.buildWithEvidence(comment).lines());
                    continue;
                }
                lines.addAll(fbuilder.build(comment).lines());
                continue;
            }
            if (showEvidence) {
                lines.add(fbuilder.buildStringWithEvidence(comment));
                continue;
            }
            lines.add(fbuilder.buildString(comment));
        }
        return lines;
    }
}

