/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.provider.twowayblast;

import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.datatype.TwoWayBlastMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.transformation.dataset.TwoWayBlastTransformation;
import org.sing_group.seda.blast.transformation.dataset.TwoWayBlastTransformationBuilder;
import org.sing_group.seda.blast.transformation.provider.twowayblast.TwoWayBlastTransformationConfigurationChangeType;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class TwoWayBlastTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private BlastBinariesExecutor blastBinariesExecutor;
    @XmlElement
    private boolean storeDatabases;
    @XmlElement
    private File databasesDirectory;
    @XmlElement
    private TwoWayBlastMode queryMode;
    @XmlElement
    private BlastType blastType;
    @XmlElement
    private File queryFile;
    @XmlElement
    private double eValue;
    @XmlElement
    private String additionalParameters;
    @XmlElement
    private int numThreads;

    public TwoWayBlastTransformationProvider() {
    }

    public TwoWayBlastTransformationProvider(TwoWayBlastMode queryMode, BlastType blastType, double eValue, String additionalParameters, int numThreads) {
        this.queryMode = queryMode;
        this.blastType = blastType;
        this.eValue = eValue;
        this.additionalParameters = additionalParameters;
        this.numThreads = numThreads;
    }

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.queryMode == null) {
                validationErrors.add("The database query mode can't be null");
            }
            if (this.blastType == null) {
                validationErrors.add("The blast type mode can't be null");
            }
            if (this.queryFile == null) {
                validationErrors.add("The query file can't be null");
            }
            if (this.numThreads < 1) {
                validationErrors.add("The number of threads can't be less than one");
            }
            if (this.storeDatabases && this.databasesDirectory == null) {
                validationErrors.add("The databases directory can't be null");
            }
            if (!this.isValidBlastBinariesExecutor()) {
                validationErrors.add("The BLAST binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getBlastTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidBlastBinariesExecutor() {
        if (this.blastBinariesExecutor == null) {
            return false;
        }
        try {
            this.blastBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return this.getBlastTransformation(factory);
    }

    private TwoWayBlastTransformation getBlastTransformation(DatatypeFactory factory) {
        TwoWayBlastTransformationBuilder builder = new TwoWayBlastTransformationBuilder(this.blastType, this.queryFile, this.queryMode).withDatatypeFactory(factory).withEvalue(this.eValue).withBlastAditionalParameters(this.additionalParameters).withNumThreads(this.numThreads).withBlastBinariesExecutor(this.blastBinariesExecutor);
        if (this.storeDatabases) {
            builder.withDatabasesDirectory(this.databasesDirectory);
        }
        return builder.build();
    }

    public void setBlastBinariesExecutor(Optional<BlastBinariesExecutor> blastBinariesExecutor) {
        this.blastBinariesExecutor = blastBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.BLAST_EXECUTOR_CHANGED, this.blastBinariesExecutor);
    }

    public BlastBinariesExecutor getBlastBinariesExecutor() {
        return this.blastBinariesExecutor;
    }

    public void setStoreDatabases(boolean storeDatabases) {
        if (this.storeDatabases != storeDatabases) {
            this.storeDatabases = storeDatabases;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.STORE_DATABASES_CHANGED, this.storeDatabases);
        }
    }

    public boolean isStoreDatabases() {
        return this.storeDatabases;
    }

    public void clearDatabasesDirectory() {
        this.databasesDirectory = null;
        this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.DATABASES_DIRECTORY_CHANGED, this.databasesDirectory);
    }

    public void setDatabasesDirectory(File databasesDirectory) {
        if (this.databasesDirectory == null || !this.databasesDirectory.equals(databasesDirectory)) {
            this.databasesDirectory = databasesDirectory;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.DATABASES_DIRECTORY_CHANGED, this.databasesDirectory);
        }
    }

    public File getDatabasesDirectory() {
        return this.databasesDirectory;
    }

    public void setQueryMode(TwoWayBlastMode queryMode) {
        if (this.queryMode == null || !this.queryMode.equals((Object)queryMode)) {
            this.queryMode = queryMode;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.QUERY_MODE_CHANGED, (Object)this.queryMode);
        }
    }

    public TwoWayBlastMode getQueryMode() {
        return this.queryMode;
    }

    public void setBlastType(BlastType blastType) {
        if (this.blastType == null || !this.blastType.equals((Object)blastType)) {
            this.blastType = blastType;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.BLAST_TYPE_CHANGED, (Object)this.blastType);
        }
    }

    public BlastType getBlastType() {
        return this.blastType;
    }

    public void clearQueryFile() {
        this.queryFile = null;
        this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
    }

    public void setQueryFile(File queryFile) {
        if (this.queryFile == null || !this.queryFile.equals(queryFile)) {
            this.queryFile = queryFile;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
        }
    }

    public File getQueryFile() {
        return this.queryFile;
    }

    public void setEvalue(double eValue) {
        if (this.eValue != eValue) {
            this.eValue = eValue;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.E_VALUE_CHANGED, this.eValue);
        }
    }

    public double geteValue() {
        return this.eValue;
    }

    public void setAdditionalParameters(String additionalParameters) {
        if (this.additionalParameters == null || !this.additionalParameters.equals(additionalParameters)) {
            this.additionalParameters = additionalParameters;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.BLAST_ADDITONAL_PARAMETERS_CHANGED, this.additionalParameters);
        }
    }

    public String getAdditionalParameters() {
        return this.additionalParameters == null ? "" : this.additionalParameters;
    }

    public void setNumThreads(int numThreads) {
        if (this.numThreads != numThreads) {
            this.numThreads = numThreads;
            this.fireTransformationsConfigurationModelEvent(TwoWayBlastTransformationConfigurationChangeType.NUM_THREADS_CHANGED, this.numThreads);
        }
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

