/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DockerBlastBinariesExecutor;
import org.sing_group.seda.blast.plugin.core.BlastSedaPluginInfo;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<BlastBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public DockerExecutionConfigurationPanel() {
        super(DockerBlastBinariesExecutor.getDefaultDockerImage(), BlastSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<BlastBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "Blast checked successfully.", "Check Blast", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking Blast: " + e.getCommand() + ".", "Error checking Blast", 0);
        }
    }

    @Override
    public Optional<BlastBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerBlastBinariesExecutor(selectedDockerImage));
    }
}

