/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.AbstractBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastEnvironment;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;

@XmlRootElement
public class DockerBlastBinariesExecutor
extends AbstractBlastBinariesExecutor {
    @XmlTransient
    private final BlastEnvironment blast = BlastEnvironment.getInstance();
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerBlastBinariesExecutor() {
        this(DockerBlastBinariesExecutor.getDefaultDockerImage());
    }

    public DockerBlastBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    public void blastDbCmd(File aliasFile, File entryBatchFile, File outFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(aliasFile.getParent());
        directoriesToMount.add(outFile.getParent());
        directoriesToMount.addAll(this.parseAliasFileDbList(aliasFile));
        super.blastDbCmd(this.composeBlastCommand(this.dockerImage, directoriesToMount, this.blast.getBlastDbCmdCommand()), aliasFile, entryBatchFile, outFile);
    }

    @Override
    public void blastDbCmd(File aliasFile, String subjectSequenceID, String range, File outFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(aliasFile.getParent());
        directoriesToMount.add(outFile.getParent());
        directoriesToMount.addAll(this.parseAliasFileDbList(aliasFile));
        super.blastDbCmd(this.composeBlastCommand(this.dockerImage, directoriesToMount, this.blast.getBlastDbCmdCommand()), aliasFile, subjectSequenceID, range, outFile);
    }

    @Override
    public void blastDbCmd(File aliasFile, String subjectSequenceID, File outFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(aliasFile.getParent());
        directoriesToMount.add(outFile.getParent());
        directoriesToMount.addAll(this.parseAliasFileDbList(aliasFile));
        super.blastDbCmd(this.composeBlastCommand(this.dockerImage, directoriesToMount, this.blast.getBlastDbCmdCommand()), aliasFile, subjectSequenceID, outFile);
    }

    private Set<String> parseAliasFileDbList(File aliasFile) {
        HashSet<String> dbDirectories = new HashSet<String>();
        Optional<File> blastAliasFile = this.findAliasFile(aliasFile);
        if (blastAliasFile.isPresent()) {
            try {
                Files.readAllLines(blastAliasFile.get().toPath()).stream().forEach(l -> {
                    if (l.startsWith("DBLIST")) {
                        String[] dirs;
                        for (String dir : dirs = l.replace("DBLIST ", "").split(" ")) {
                            String dbDir = dir.replace("\"", "");
                            int lastIndex = dbDir.lastIndexOf("/");
                            if (lastIndex < 0) continue;
                            dbDir = dbDir.substring(0, lastIndex);
                            dbDirectories.add(dbDir);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dbDirectories;
    }

    private Optional<File> findAliasFile(File aliasFile) {
        File nalAliasFile = new File(aliasFile.getAbsolutePath() + ".nal");
        if (nalAliasFile.exists()) {
            return Optional.of(nalAliasFile);
        }
        File palAliasFile = new File(aliasFile.getAbsolutePath() + ".pal");
        if (palAliasFile.exists()) {
            return Optional.of(palAliasFile);
        }
        return Optional.empty();
    }

    @Override
    public void makeBlastDb(File inFile, String blastSequenceType, File dbFile, boolean parseSeqIds) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(inFile.getParent());
        directoriesToMount.add(dbFile.getParent());
        directoriesToMount.addAll(this.parseAliasFileDbList(dbFile));
        super.makeBlastDb(this.composeBlastCommand(this.dockerImage, directoriesToMount, this.blast.getMakeBlastDbCommand()), inFile, blastSequenceType, dbFile, parseSeqIds);
    }

    @Override
    public void makeDbAlias(List<File> blastDatabases, String blastSequenceType, File outFile, String dbAliasTitle) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        blastDatabases.forEach(file -> directoriesToMount.add(file.getParent()));
        directoriesToMount.add(outFile.getParent());
        super.makeDbAlias(this.composeBlastCommand(this.dockerImage, directoriesToMount, this.blast.getBlastDbAliasToolCommand()), blastDatabases, blastSequenceType, outFile, dbAliasTitle);
    }

    @Override
    public void executeBlast(BlastType blastType, File queryFile, File dbFile, double expectedValue, int maxTargetSeqs, File outFile, String outFormat, List<String> additionalBlastParameters) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(queryFile.getParent());
        directoriesToMount.add(dbFile.getParent());
        directoriesToMount.add(outFile.getParent());
        directoriesToMount.addAll(this.parseAliasFileDbList(dbFile));
        super.executeBlast(this.composeBlastCommand(this.dockerImage, directoriesToMount, blastType.getCommand()), blastType, queryFile, dbFile, expectedValue, maxTargetSeqs, outFile, outFormat, additionalBlastParameters);
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-blast";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    @Override
    protected String composeBlastCommand(String command) {
        return this.composeBlastCommand(this.dockerImage, command);
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    private List<String> composeBlastCommand(String blastImage, Set<String> directoriesToMount, String command) {
        return Arrays.asList(("docker run --rm " + DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount) + " " + blastImage + " " + command).split(" "));
    }

    private String composeBlastCommand(String blastImage, String command) {
        return "docker run --rm " + blastImage + " " + command;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

