/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.cli.blast;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.FileOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.blast.datatype.DatabaseQueryMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.AbstractBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DefaultBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.DockerBlastBinariesExecutor;
import org.sing_group.seda.blast.plugin.core.BlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.blast.BlastTransformationProvider;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class BlastCommand
extends ExternalSoftwareExecutionCommand {
    public static final StringOption OPTION_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The BLAST docker image. By default, the official SEDA image for BLAST is used. If you provide a custom image, it should have the BLAST commands available in the path.", true, true);
    public static final StringOption OPTION_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "local-mode", "lc", "The directory that contains the BLAST binaries. Leave it empty if they are in the path.", true, true);
    public static final FileOption OPTION_QUERY_FILE = new FileOption("query-file", "qf", "The file that contains the sequences that must be used for the BLAST queries.", true, true);
    public static final DefaultValuedStringOption OPTION_DATABASE_QUERY_MODE = new DefaultValuedStringOption("query-mode", "qm", BlastSedaPluginInfo.PARAM_DATABASE_QUERY_MODE_HELP, BlastSedaPluginInfo.DEFAULT_DATABAE_QUERY_MODE.name().toLowerCase());
    public static final DefaultValuedStringOption OPTION_QUERY_BLAST_TYPE_MODE = new DefaultValuedStringOption("query-blast-type", "qbt", BlastSedaPluginInfo.PARAM_QUERY_BLAST_TYPE_HELP, BlastSedaPluginInfo.DEFAULT_BLAST_TYPE.name().toLowerCase());
    public static final FileOption OPTION_STORE_DATABASES_DIRECTORY = new FileOption("store-databases-directory", "sdd", "The directory where databases must be stored.", true, true);
    public static final FileOption OPTION_STORE_ALIAS_FILE = new FileOption("store-alias-file", "saf", "The file where the alias must be stored.", true, true);
    public static final DefaultValuedStringOption OPTION_EVALUE = new DefaultValuedStringOption("evalue", "ev", "The expectation value (E) threshold for saving hits.", Double.toString(0.05));
    public static final DefaultValuedStringOption OPTION_MAX_TARGET_SEQS = new DefaultValuedStringOption("max-target-seqs", "mts", "The maximum number of aligned sequences to keep.", Integer.toString(500000));
    public static final StringOption OPTION_HIT_REGION_WINDOW_SIZE = new StringOption("hit-regions-window", "hrg", "The window size to retrieve only hit regions.", true, true);
    public static final StringOption OPTION_ADDITIONAL_PARAMS = new StringOption("additional-params", "ad", "Additional parameters for the BLAST command.", true, true);

    public String getName() {
        return "blast";
    }

    public String getDescriptiveName() {
        return "BLAST";
    }

    public String getDescription() {
        return "Perform BLAST queries using the selected FASTA files as a single or mutiple independent database(s).";
    }

    @Override
    protected String getSedaGroup() {
        return BlastSedaPluginInfo.GROUP;
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return BlastCommand.fromKeyValue(OPTION_LOCAL_MODE, "seda.local.execution.enabled.blast");
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_LOCAL_MODE);
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_LOCAL_MODE, OPTION_DOCKER_MODE, OPTION_QUERY_FILE, OPTION_DATABASE_QUERY_MODE, OPTION_QUERY_BLAST_TYPE_MODE, OPTION_STORE_DATABASES_DIRECTORY, OPTION_STORE_ALIAS_FILE, OPTION_EVALUE, OPTION_MAX_TARGET_SEQS, OPTION_HIT_REGION_WINDOW_SIZE, OPTION_ADDITIONAL_PARAMS);
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_QUERY_FILE);
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        Optional<String> additionalParameters;
        Optional<Integer> hitRegionWindowSize;
        Optional<File> aliasFile;
        BlastTransformationProvider provider = new BlastTransformationProvider();
        provider.setBlastType(this.getBlastType(parameters));
        provider.setQueryFile(this.getExistingFile(parameters, OPTION_QUERY_FILE));
        provider.setDatabaseQueryMode(this.getDatabaseQueryMode(parameters));
        provider.setEvalue(this.getEvalue(parameters));
        provider.setMaxTargetSeqs(this.getMaxTargetSeqs(parameters));
        Optional<File> databasesDirectory = BlastCommand.getDatabasesDirectory(parameters, OPTION_STORE_DATABASES_DIRECTORY);
        if (databasesDirectory.isPresent()) {
            provider.setStoreDatabases(true);
            provider.setDatabasesDirectory(databasesDirectory.get());
        }
        if ((aliasFile = this.getAliasFile(parameters)).isPresent()) {
            provider.setStoreAlias(true);
            provider.setAliasFile(aliasFile.get());
        }
        if ((hitRegionWindowSize = this.getHitRegionWindowSize(parameters)).isPresent()) {
            provider.setExtractOnlyHitRegions(true);
            provider.setHitRegionsWindowSize(hitRegionWindowSize.get());
        }
        if ((additionalParameters = this.getAdditionalParameters(parameters)).isPresent()) {
            provider.setAdditionalParameters(additionalParameters.get());
        }
        provider.setBlastBinariesExecutor(Optional.of(BlastCommand.getBlastBinariesExecutor(parameters, OPTION_LOCAL_MODE, OPTION_DOCKER_MODE)));
        return provider;
    }

    public static BlastBinariesExecutor getBlastBinariesExecutor(Parameters parameters, StringOption localMode, StringOption dockerMode) {
        BlastCommand.validateSingleExecutionMode(parameters, localMode, dockerMode);
        AbstractBlastBinariesExecutor executor = new DockerBlastBinariesExecutor(DockerBlastBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)localMode)) {
            File blastBinariesDirectory = new File(parameters.getSingleValueString((Option)localMode));
            if (blastBinariesDirectory.isDirectory()) {
                executor = new DefaultBlastBinariesExecutor(blastBinariesDirectory);
            } else {
                BlastCommand.formattedValidationError("The specified BLAST directory does not exist or it is not a directory.");
            }
        }
        if (parameters.hasOption((Option)dockerMode)) {
            executor = new DockerBlastBinariesExecutor((String)parameters.getSingleValue((Option)dockerMode));
        }
        return executor;
    }

    private Optional<String> getAdditionalParameters(Parameters parameters) {
        if (!parameters.hasOption((Option)OPTION_ADDITIONAL_PARAMS)) {
            return Optional.empty();
        }
        return Optional.of((String)parameters.getSingleValue((Option)OPTION_ADDITIONAL_PARAMS));
    }

    private Optional<Integer> getHitRegionWindowSize(Parameters parameters) {
        if (!parameters.hasOption((Option)OPTION_HIT_REGION_WINDOW_SIZE)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.valueOf((String)parameters.getSingleValue((Option)OPTION_HIT_REGION_WINDOW_SIZE)));
        }
        catch (NumberFormatException ex) {
            BlastCommand.formattedValidationError("Invalid value for " + BlastCommand.formatParam(OPTION_HIT_REGION_WINDOW_SIZE) + " (" + (String)parameters.getSingleValue((Option)OPTION_HIT_REGION_WINDOW_SIZE) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    private int getMaxTargetSeqs(Parameters parameters) {
        try {
            return Integer.valueOf((String)parameters.getSingleValue((Option)OPTION_MAX_TARGET_SEQS));
        }
        catch (NumberFormatException ex) {
            BlastCommand.formattedValidationError("Invalid value for " + BlastCommand.formatParam(OPTION_MAX_TARGET_SEQS) + " (" + (String)parameters.getSingleValue((Option)OPTION_MAX_TARGET_SEQS) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    private double getEvalue(Parameters parameters) {
        try {
            return Double.valueOf((String)parameters.getSingleValue((Option)OPTION_EVALUE));
        }
        catch (NumberFormatException ex) {
            BlastCommand.formattedValidationError("Invalid value for " + BlastCommand.formatParam(OPTION_EVALUE) + " (" + (String)parameters.getSingleValue((Option)OPTION_EVALUE) + "). It must be a number.");
            throw new IllegalStateException();
        }
    }

    private Optional<File> getAliasFile(Parameters parameters) {
        if (!parameters.hasOption((Option)OPTION_STORE_ALIAS_FILE)) {
            return Optional.empty();
        }
        File aliasFile = (File)parameters.getSingleValue((Option)OPTION_STORE_ALIAS_FILE);
        if (aliasFile.getParentFile().canWrite()) {
            return Optional.of(aliasFile);
        }
        BlastCommand.formattedValidationError("Invalid path. The path to the alias file must be writable.");
        throw new IllegalStateException();
    }

    public static Optional<File> getDatabasesDirectory(Parameters parameters, FileOption optionStoreDatabasesDirectory) {
        if (!parameters.hasOption((Option)optionStoreDatabasesDirectory)) {
            return Optional.empty();
        }
        File databasesDirectory = (File)parameters.getSingleValue((Option)optionStoreDatabasesDirectory);
        if (!(databasesDirectory.exists() || databasesDirectory.isDirectory() || databasesDirectory.mkdirs())) {
            BlastCommand.formattedValidationError("Invalid path. The path to the databases directory does not exist and it can't be created.");
        }
        return Optional.of(databasesDirectory);
    }

    private DatabaseQueryMode getDatabaseQueryMode(Parameters parameters) {
        try {
            return DatabaseQueryMode.valueOf(parameters.getSingleValueString((Option)OPTION_DATABASE_QUERY_MODE).toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            BlastCommand.invalidEnumValue(OPTION_DATABASE_QUERY_MODE);
            throw new IllegalStateException();
        }
    }

    private BlastType getBlastType(Parameters parameters) {
        try {
            return BlastType.valueOf(parameters.getSingleValueString((Option)OPTION_QUERY_BLAST_TYPE_MODE).toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            BlastCommand.invalidEnumValue(OPTION_DATABASE_QUERY_MODE);
            throw new IllegalStateException();
        }
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, BlastTransformationProvider.class);
    }
}

