/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.emboss.getorf.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTextField;
import org.sing_group.gc4s.event.RunnableDocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.JIntegerTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.emboss.core.EmbossGetOrfSedaPluginInfo;
import org.sing_group.seda.emboss.execution.EmbossBinariesExecutor;
import org.sing_group.seda.emboss.getorf.datatype.FindParam;
import org.sing_group.seda.emboss.getorf.datatype.TableParam;
import org.sing_group.seda.emboss.gui.EmbossExecutionConfigurationPanel;
import org.sing_group.seda.emboss.transformation.provider.GetOrfTransformationProvider;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class GetOrfTransformationConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GetOrfTransformationProvider transformationProvider;
    private JComboBox<TableParam> tableCombobox;
    private JComboBox<FindParam> findCombobox;
    private JIntegerTextField minSize;
    private JIntegerTextField maxSize;
    private JXTextField additionalParameters;
    private EmbossExecutionConfigurationPanel embossExecutionConfigurationPanel;

    public GetOrfTransformationConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void initTransformationProvider() {
        this.transformationProvider = new GetOrfTransformationProvider((TableParam)((Object)this.tableCombobox.getSelectedItem()), (FindParam)((Object)this.findCombobox.getSelectedItem()), this.minSize.getValue(), this.maxSize.getValue(), this.additionalParameters.getText());
        this.embossExecutorChanged();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)this.getEmbossConfigurationPanel());
        mainPanel.add((Component)this.getOperationConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private InputParametersPanel getEmbossConfigurationPanel() {
        InputParametersPanel embossConfigurationPanel = new InputParametersPanel(this.getEmbossConfigurationParameters());
        embossConfigurationPanel.setBorder((Border)BorderFactory.createTitledBorder("EMBOSS configuration"));
        return embossConfigurationPanel;
    }

    private InputParameter[] getEmbossConfigurationParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getEmbossExecutableParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getEmbossExecutableParameter() {
        this.embossExecutionConfigurationPanel = new EmbossExecutionConfigurationPanel(this::embossExecutorChanged);
        return new InputParameter("", (JComponent)this.embossExecutionConfigurationPanel, "The mode to execute EMBOSS.");
    }

    private void embossExecutorChanged(BinaryExecutionConfigurationPanel<EmbossBinariesExecutor> source) {
        this.embossExecutorChanged();
    }

    private void embossExecutorChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setEmbossBinariesExecutor(this.embossExecutionConfigurationPanel.getBinariesExecutor()));
    }

    private InputParametersPanel getOperationConfigurationPanel() {
        return new InputParametersPanel(this.getParameters());
    }

    private InputParameter[] getParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getTableParameter());
        parameters.add(this.getFindParameter());
        parameters.add(this.getMinSizeParameter());
        parameters.add(this.getMaxSizeParameter());
        parameters.add(this.getAdditionalParamsParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getTableParameter() {
        this.tableCombobox = new JComboBox<TableParam>(TableParam.values());
        this.tableCombobox.addItemListener(this::tableChanged);
        return new InputParameter("Table: ", this.tableCombobox, "The code to use.");
    }

    private void tableChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.tableChanged();
        }
    }

    private void tableChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setTable((TableParam)((Object)((Object)this.tableCombobox.getSelectedItem()))));
    }

    private InputParameter getFindParameter() {
        this.findCombobox = new JComboBox<FindParam>(FindParam.values());
        this.findCombobox.addItemListener(this::findChanged);
        return new InputParameter("Find: ", this.findCombobox, EmbossGetOrfSedaPluginInfo.PARAM_FIND_HELP_GUI);
    }

    private void findChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.findChanged();
        }
    }

    private void findChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setFind((FindParam)((Object)((Object)this.findCombobox.getSelectedItem()))));
    }

    private InputParameter getMinSizeParameter() {
        this.minSize = new JIntegerTextField(Integer.valueOf(30));
        this.minSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(() -> this.minSizeChanged()));
        return new InputParameter("Min. size: ", (JComponent)this.minSize, "The minimum nucleotide size of ORF to report (any integer value).");
    }

    private void minSizeChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setMinSize(this.minSize.getValue()));
    }

    private InputParameter getMaxSizeParameter() {
        this.maxSize = new JIntegerTextField(Integer.valueOf(10000));
        this.maxSize.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(() -> this.maxSizeChanged()));
        return new InputParameter("Max. size: ", (JComponent)this.maxSize, "The maximum nucleotide size of ORF to report (any integer value).");
    }

    private void maxSizeChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setMaxSize(this.maxSize.getValue()));
    }

    private InputParameter getAdditionalParamsParameter() {
        this.additionalParameters = new JXTextField("Additional parameters for getorf");
        this.additionalParameters.getDocument().addDocumentListener((DocumentListener)new RunnableDocumentAdapter(() -> this.getOrfAdditionalParametersChanged()));
        return new InputParameter("Additional parameters: ", (JComponent)this.additionalParameters, "Additional parameters for the EMBOSS getorf command.");
    }

    private void getOrfAdditionalParametersChanged() {
        SwingUtilities.invokeLater(() -> this.transformationProvider.setAdditionalParameters(this.additionalParameters.getText()));
    }

    public GetOrfTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(GetOrfTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getTable() != null) {
            this.tableCombobox.setSelectedItem((Object)this.transformationProvider.getTable());
        }
        if (this.transformationProvider.getFind() != null) {
            this.tableCombobox.setSelectedItem((Object)this.transformationProvider.getFind());
        }
        this.minSize.setValue((Object)this.transformationProvider.getMinSize());
        this.maxSize.setValue((Object)this.transformationProvider.getMaxSize());
        this.additionalParameters.setText(this.transformationProvider.getAdditionalParameters());
        if (this.transformationProvider.getEmbossBinariesExecutor() != null) {
            this.embossExecutionConfigurationPanel.setBinariesExecutor(this.transformationProvider.getEmbossBinariesExecutor());
        }
    }
}

