/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;
import org.sing_group.seda.prosplign.execution.DockerProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.plugin.core.ProSplignCompartPipelineSedaPluginInfo;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<ProSplignCompartBinariesExecutor> {
    private static final long serialVersionUID = 1L;

    public DockerExecutionConfigurationPanel() {
        super(DockerProSplignCompartBinariesExecutor.getDefaultDockerImage(), ProSplignCompartPipelineSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<ProSplignCompartBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "ProSplign/ProCompart binaries checked successfully.", "Check ProSplign/ProCompart binaries", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking ProSplign/ProCompart binaries: " + e.getCommand() + ".", "Error checking ProSplign/ProCompart", 0);
        }
    }

    @Override
    public Optional<ProSplignCompartBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerProSplignCompartBinariesExecutor(selectedDockerImage));
    }
}

