/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.gn;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.GnLineParser;
import uk.ac.ebi.uniprot.parser.antlr.GnLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.HasEvidence;
import uk.ac.ebi.uniprot.parser.impl.gn.GnLineObject;

public class GnLineModelListener
extends GnLineParserBaseListener
implements ParseTreeObjectExtractor<GnLineObject> {
    private GnLineObject object;

    @Override
    public void enterGn_gn(GnLineParser.Gn_gnContext ctx) {
        this.object = new GnLineObject();
    }

    @Override
    public void exitGn_line_block(GnLineParser.Gn_line_blockContext ctx) {
        GnLineObject.GnObject gnObject = new GnLineObject.GnObject();
        List<GnLineParser.One_nameContext> oneNameContexts = ctx.one_name();
        for (GnLineParser.One_nameContext context : oneNameContexts) {
            String text;
            GnLineParser.EvidenceContext evidence;
            List<GnLineParser.NameContext> names;
            GnLineObject.GnName gnName;
            if (context.gene_name() != null) {
                GnLineParser.Gene_nameContext geneNameContext = context.gene_name();
                gnName = new GnLineObject.GnName();
                gnName.type = GnLineObject.GnNameType.GENAME;
                GnLineParser.NameContext name = geneNameContext.name();
                GnLineParser.EvidenceContext evidence2 = name.evidence();
                String text2 = name.words().getText();
                gnName.names.add(text2);
                this.addEvidenceForName(text2, evidence2, gnName);
                gnObject.names.add(gnName);
                continue;
            }
            if (context.syn_name() != null) {
                GnLineParser.Syn_nameContext synNameContext = context.syn_name();
                gnName = new GnLineObject.GnName();
                gnName.type = GnLineObject.GnNameType.SYNNAME;
                names = synNameContext.names().name();
                for (GnLineParser.NameContext name : names) {
                    evidence = name.evidence();
                    text = name.words().getText();
                    gnName.names.add(text);
                    this.addEvidenceForName(text, evidence, gnName);
                }
                gnObject.names.add(gnName);
                continue;
            }
            if (context.orf_name() != null) {
                GnLineParser.Orf_nameContext orfNameContext = context.orf_name();
                gnName = new GnLineObject.GnName();
                gnName.type = GnLineObject.GnNameType.ORFNAME;
                names = orfNameContext.names().name();
                for (GnLineParser.NameContext name : names) {
                    evidence = name.evidence();
                    text = name.words().getText();
                    gnName.names.add(text);
                    this.addEvidenceForName(text, evidence, gnName);
                }
                gnObject.names.add(gnName);
                continue;
            }
            if (context.ol_name() == null) continue;
            GnLineParser.Ol_nameContext olNameContext = context.ol_name();
            gnName = new GnLineObject.GnName();
            gnName.type = GnLineObject.GnNameType.OLNAME;
            names = olNameContext.names().name();
            for (GnLineParser.NameContext name : names) {
                evidence = name.evidence();
                text = name.words().getText();
                gnName.names.add(text);
                this.addEvidenceForName(text, evidence, gnName);
            }
            gnObject.names.add(gnName);
        }
        this.object.gnObjects.add(gnObject);
    }

    private void addEvidenceForName(String text, GnLineParser.EvidenceContext evidence, HasEvidence container) {
        if (evidence == null) {
            return;
        }
        EvidenceInfo evidenceInfo = container.getEvidenceInfo();
        List<TerminalNode> terminalNodes = evidence.EV_TAG();
        ArrayList<String> strings = new ArrayList<String>();
        for (TerminalNode terminalNode : terminalNodes) {
            String text1 = terminalNode.getText();
            strings.add(text1);
        }
        evidenceInfo.evidences.put(text, strings);
    }

    @Override
    public GnLineObject getObject() {
        return this.object;
    }
}

