/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.entry;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.impl.ra.RaLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rc.RcLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rg.RgLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rl.RlLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rn.RnLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rp.RpLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rt.RtLineConverter;
import uk.ac.ebi.uniprot.parser.impl.rx.RxLineConverter;

public class ReferenceObjectConverter
extends EvidenceIdCollector
implements Converter<EntryObject.ReferenceObject, Citation> {
    private final RaLineConverter raLineConverter = new RaLineConverter();
    private final RcLineConverter rcLineConverter = new RcLineConverter();
    private final RgLineConverter rgLineConverter = new RgLineConverter();
    private final RlLineConverter rlLineConverter = new RlLineConverter();
    private final RnLineConverter rnLineConverter = new RnLineConverter();
    private final RpLineConverter rpLineConverter = new RpLineConverter();
    private final RtLineConverter rtLineConverter = new RtLineConverter();
    private final RxLineConverter rxLineConverter = new RxLineConverter();

    @Override
    public Citation convert(EntryObject.ReferenceObject f) {
        Citation citation = this.rlLineConverter.convert(f.rl);
        if (f.ra != null) {
            List<Author> authors = this.raLineConverter.convert(f.ra);
            citation.setAuthors(authors);
        }
        citation.setEvidenceIds(this.rnLineConverter.convert(f.rn));
        if (f.rc != null) {
            citation.setSampleSources(this.rcLineConverter.convert(f.rc));
        }
        if (f.rg != null) {
            citation.setAuthoringGroup(this.rgLineConverter.convert(f.rg));
        }
        if (f.rp != null) {
            citation.setCitationSummary(this.rpLineConverter.convert(f.rp));
        }
        if (f.rt != null) {
            citation.setTitle(this.rtLineConverter.convert(f.rt));
        }
        if (f.rx != null) {
            citation.setCitationsXrefs(this.rxLineConverter.convert(f.rx));
        }
        this.updateEvidences();
        return citation;
    }

    private void updateEvidences() {
        this.add(this.rnLineConverter.getEvidences());
        this.add(this.rcLineConverter.getEvidences());
    }

    @Override
    public void clear() {
        super.clear();
        this.rnLineConverter.clear();
        this.rcLineConverter.clear();
    }
}

