/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.HasEvidence;

public class CcLineObject
implements HasEvidence {
    public List<CC> ccs = new ArrayList<CC>();
    public EvidenceInfo evidenceInfo = new EvidenceInfo();

    @Override
    public EvidenceInfo getEvidenceInfo() {
        return this.evidenceInfo;
    }

    public static class CAPhysioDirection {
        public String name;
        public String xref;
    }

    public static class CAReaction {
        public String name;
        public String xref;
        public String ec;
    }

    public static class CatalyticActivity {
        public String molecule;
        public CAReaction reaction;
        public List<CAPhysioDirection> physiologicalDirections = new ArrayList<CAPhysioDirection>();
    }

    public static class FreeText {
        public List<EvidencedString> texts = new ArrayList<EvidencedString>();
    }

    public static class CofactorItem {
        public String name;
        public String xref;
    }

    public static class StructuredCofactor {
        public String molecule;
        public List<EvidencedString> note = new ArrayList<EvidencedString>();
        public List<CofactorItem> cofactors = new ArrayList<CofactorItem>();
    }

    public static class Disease {
        public String molecule;
        public String name;
        public String abbr;
        public String mim;
        public String description;
        public List<EvidencedString> note = new ArrayList<EvidencedString>();
    }

    public static class MassSpectrometryRange {
        public int start;
        public boolean startUnknown;
        public int end;
        public boolean endUnknown;
        public String rangeIsoform;
    }

    public static class MassSpectrometry {
        public float mass;
        public float massError;
        public String method;
        public String note;
        public List<String> sources = new ArrayList<String>();
        public String molecule;
    }

    public static class SequenceCautionObject {
        public String sequence;
        public SequenceCautionType type;
        public String note;
    }

    public static enum SequenceCautionType {
        FRAMESHIFT,
        ERRONEOUS_INITIATION,
        ERRONEOUS_TERMINATION,
        ERRONEOUS_GENE_MODEL_PREDICTION,
        ERRONEOUS_TRANSLATION,
        MISCELLANEOUS_DISCREPANCY;


        public static SequenceCautionType fromSting(String s) {
            String replace = s.replace(' ', '_');
            return SequenceCautionType.valueOf(replace.toUpperCase());
        }
    }

    public static class SequenceCaution {
        public String molecule;
        public List<SequenceCautionObject> sequenceCautionObjects = new ArrayList<SequenceCautionObject>();
    }

    public static enum RnaEditingLocationEnum {
        UNDETERMINED,
        NOT_APPLICABLE;

    }

    public static class RnaEditing {
        public RnaEditingLocationEnum locationEnum;
        public List<Integer> locations = new ArrayList<Integer>();
        public List<EvidencedString> note = new ArrayList<EvidencedString>();
        public String molecule;
    }

    public static enum LocationFlagEnum {
        BY_SIMILARITY,
        PROBABLE,
        POTENTIAL,
        FLAG;


        public static LocationFlagEnum fromSting(String s) {
            String s1 = s.toLowerCase();
            if (s1.indexOf("by") >= 0 && s.indexOf("similarity") > 0) {
                return BY_SIMILARITY;
            }
            if (s1.indexOf("probable") >= 0) {
                return PROBABLE;
            }
            if (s1.indexOf("potential") >= 0) {
                return POTENTIAL;
            }
            throw new RuntimeException(s + " cannot be parsed to the location flag");
        }
    }

    public static class LocationObject {
        public LocationValue subcellularLocation;
        public LocationValue topology;
        public LocationValue orientation;
    }

    public static class LocationValue {
        public String value;
        public LocationFlagEnum flag;
    }

    public static class SubcullarLocation {
        public String molecule;
        public List<LocationObject> locations = new ArrayList<LocationObject>();
        public List<EvidencedString> note = new ArrayList<EvidencedString>();
    }

    public static class InteractionObject {
        public String firstInteractant;
        public String secondInteractant;
        public String secondInteractantParent;
        public String gene;
        public boolean xeno;
        public int nbexp;
        public String firstId;
        public String secondId;
    }

    public static class Interaction {
        public List<InteractionObject> interactions = new ArrayList<InteractionObject>();
    }

    public static enum CCTopicEnum {
        ALLERGEN,
        BIOTECHNOLOGY,
        CATALYTIC_ACTIVITY,
        CAUTION,
        COFACTOR,
        DEVELOPMENTAL_STAGE,
        DISEASE,
        DISRUPTION_PHENOTYPE,
        DOMAIN,
        ENZYME_REGULATION,
        FUNCTION,
        INDUCTION,
        MISCELLANEOUS,
        PATHWAY,
        PHARMACEUTICAL,
        POLYMORPHISM,
        PTM,
        SIMILARITY,
        SUBUNIT,
        TISSUE_SPECIFICITY,
        TOXIC_DOSE,
        ALTERNATIVE_PRODUCTS,
        BIOPHYSICOCHEMICAL_PROPERTIES,
        WEB_RESOURCE,
        INTERACTION,
        SUBCELLULAR_LOCATION,
        SEQUENCE_CAUTION,
        MASS_SPECTROMETRY,
        RNA_EDITING;


        public static CCTopicEnum fromSting(String s) {
            String replace = s.replace(' ', '_');
            if (replace.equals("ACTIVITY_REGULATION")) {
                replace = "ENZYME_REGULATION";
            }
            return CCTopicEnum.valueOf(replace);
        }
    }

    public static class WebResource {
        public String molecule;
        public String name;
        public String url;
        public String note;
    }

    public static enum AlternativeNameSequenceEnum {
        DISPLAYED,
        EXTERNAL,
        NOT_DESCRIBED,
        DESCRIBED,
        UNSURE;

    }

    public static class BiophysicochemicalProperties {
        public String molecule;
        public EvidencedString bsorptionAbs;
        public List<EvidencedString> bsorptionNote = new ArrayList<EvidencedString>();
        public List<EvidencedString> kms = new ArrayList<EvidencedString>();
        public List<EvidencedString> vmaxs = new ArrayList<EvidencedString>();
        public List<EvidencedString> kpNote = new ArrayList<EvidencedString>();
        public List<EvidencedString> phDependence = new ArrayList<EvidencedString>();
        public List<EvidencedString> rdoxPotential = new ArrayList<EvidencedString>();
        public List<EvidencedString> temperatureDependence = new ArrayList<EvidencedString>();
        public boolean bsorptionAbsApproximate;
    }

    public static class AlternativeProductName {
        public EvidencedString name;
        public List<EvidencedString> synNames = new ArrayList<EvidencedString>();
        public List<String> isoId = new ArrayList<String>();
        public List<String> sequenceFTId = new ArrayList<String>();
        public AlternativeNameSequenceEnum sequenceEnum = null;
        public List<EvidencedString> note = new ArrayList<EvidencedString>();
    }

    public static class AlternativeProducts {
        public List<String> events = new ArrayList<String>();
        public String namedIsoforms;
        public List<EvidencedString> comment = new ArrayList<EvidencedString>();
        public List<AlternativeProductName> names = new ArrayList<AlternativeProductName>();
    }

    public static class CC {
        public CCTopicEnum topic;
        public Object object;
    }

    public static class EvidencedString {
        public final String value;
        public final List<String> evidences = new ArrayList<String>();

        public EvidencedString(String value, List<String> evidences) {
            this.value = value;
            if (evidences != null) {
                this.evidences.addAll(evidences);
            }
        }

        public static EvidencedString get(String text1) {
            return new EvidencedString(text1, null);
        }

        public static EvidencedString get(String text1, List<String> strings) {
            if (strings == null || strings.isEmpty()) {
                return EvidencedString.get(text1);
            }
            return new EvidencedString(text1, strings);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvidencedString evValue = (EvidencedString)o;
            if (this.evidences != null && !this.evidences.isEmpty() ? !this.evidences.equals(evValue.evidences) : evValue.evidences != null && !evValue.evidences.isEmpty()) {
                return false;
            }
            return this.value.equals(evValue.value);
        }

        public int hashCode() {
            int result = 0;
            result = 29 * result + this.value.hashCode();
            result = 29 * result + this.evidences.hashCode();
            return result;
        }
    }
}

