/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.gocache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import uk.ac.ebi.kraken.util.net.FtpService;
import uk.ac.ebi.kraken.util.net.FtpServiceImpl;

public class GoTermDownload {
    private static final String FTP_URL = "ftp.ebi.ac.uk";
    private String path = "/pub/contrib/goa/";
    private static final String FILENAME = "GO.term_data.zip";
    private static final String USER = "anonymous";
    private final FtpServiceImpl ftpService = new FtpServiceImpl();
    private final String outputPath;
    private final RetryPolicy retryPolicy;

    public GoTermDownload(String outputPath) {
        this.outputPath = outputPath;
        this.retryPolicy = new RetryPolicy().retryOn(Arrays.asList(IOException.class)).withDelay(10L, TimeUnit.MILLISECONDS).withMaxRetries(3);
    }

    public boolean connect() throws IOException {
        return this.ftpService.connect(FTP_URL, USER, "");
    }

    public List<String> download() throws IOException {
        String inputFile = this.path + FILENAME;
        String outputFile = this.outputPath;
        return (List)Failsafe.with((RetryPolicy)this.retryPolicy).get(() -> this.doDownload(this.ftpService, inputFile, outputFile));
    }

    public void close() {
        this.ftpService.releaseConnection();
    }

    private List<String> doDownload(FtpService ftpService, String fileName, String outputPath) throws IOException {
        if (!ftpService.isConnected()) {
            ftpService.reconnect(3);
        }
        String outputFile = outputPath + File.separator + FILENAME;
        ftpService.download(fileName, outputFile, true);
        return this.unzip(outputFile, outputPath);
    }

    private List<String> unzip(String file, String outputPath) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        ZipEntry zipEntry = zis.getNextEntry();
        byte[] buffer = new byte[4096];
        ArrayList<String> results = new ArrayList<String>();
        results.add(file);
        while (zipEntry != null) {
            int len;
            String outputFile = outputPath + File.separator + zipEntry.getName();
            File newFile = new File(outputFile);
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            results.add(outputFile);
            zipEntry = zis.getNextEntry();
        }
        zis.close();
        return results;
    }
}

