/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome;

import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ConsortiumType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.DbReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.JournalType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.NameListType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.PersonType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.SubmissionType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroJournalArticle;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroReference;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroSubmission;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroXref;

public class AvroReferenceConverter
implements Converter<ReferenceType, AvroReference> {
    private final AvroJournalArticleConverter journalArticleConverter = new AvroJournalArticleConverter();
    private final AvroSubmissionConverter submissionConverter = new AvroSubmissionConverter();

    @Override
    public AvroReference toAvro(ReferenceType reference) {
        AvroReference.Builder builder = AvroReference.newBuilder();
        builder.setDate(reference.getDate());
        this.updateAvroAuthors(reference, builder);
        if (reference.getJournal() != null) {
            builder.setCitation((Object)this.journalArticleConverter.toAvro(reference.getJournal()));
        } else if (reference.getSubmission() != null) {
            builder.setCitation((Object)this.submissionConverter.toAvro(reference.getSubmission()));
        }
        return builder.build();
    }

    @Override
    public ReferenceType fromAvro(AvroReference avro) {
        ReferenceType reference = new ReferenceType();
        if (avro.getDate() != null) {
            reference.setDate(avro.getDate().toString());
        }
        this.updateReferenceAuthors(avro, reference);
        Object citation = avro.getCitation();
        if (citation != null) {
            if (citation instanceof AvroJournalArticle) {
                reference.setJournal(this.journalArticleConverter.fromAvro((AvroJournalArticle)((Object)citation)));
            } else if (citation instanceof AvroSubmission) {
                reference.setSubmission(this.submissionConverter.fromAvro((AvroSubmission)((Object)citation)));
            }
        }
        return reference;
    }

    private void updateAvroAuthors(ReferenceType reference, AvroReference.Builder builder) {
        NameListType nameList = reference.getAuthorList();
        List<Object> authors = null;
        if (nameList != null) {
            authors = nameList.getConsortiumOrPerson();
        }
        if (authors == null || authors.isEmpty()) {
            return;
        }
        builder.setConsortium(authors.stream().filter(obj -> obj instanceof ConsortiumType).map(obj -> (ConsortiumType)obj).map(obj -> obj.getName()).collect(Collectors.toList()));
        builder.setAuthor(authors.stream().filter(obj -> obj instanceof PersonType).map(obj -> (PersonType)obj).map(obj -> obj.getName()).collect(Collectors.toList()));
    }

    private void updateReferenceAuthors(AvroReference avro, ReferenceType reference) {
        List<CharSequence> consortium;
        List<CharSequence> authors = avro.getAuthor();
        NameListType nameList = new NameListType();
        if (authors != null && !authors.isEmpty()) {
            authors.stream().map(cs -> this.convertPerson((CharSequence)cs)).forEach(obj -> nameList.getConsortiumOrPerson().add(obj));
        }
        if ((consortium = avro.getConsortium()) != null && !consortium.isEmpty()) {
            consortium.stream().map(cs -> this.convertConsortium((CharSequence)cs)).forEach(obj -> nameList.getConsortiumOrPerson().add(obj));
        }
        if (!nameList.getConsortiumOrPerson().isEmpty()) {
            reference.setAuthorList(nameList);
        }
    }

    private PersonType convertPerson(CharSequence author) {
        PersonType person = new PersonType();
        person.setName(author.toString());
        return person;
    }

    private ConsortiumType convertConsortium(CharSequence cs) {
        ConsortiumType consortium = new ConsortiumType();
        consortium.setName(cs.toString());
        return consortium;
    }

    static class AvroJournalArticleConverter
    implements Converter<JournalType, AvroJournalArticle> {
        AvroJournalArticleConverter() {
        }

        @Override
        public AvroJournalArticle toAvro(JournalType journal) {
            AvroJournalArticle.Builder builder = AvroJournalArticle.newBuilder();
            builder.setFirst(journal.getFirst());
            builder.setLast(journal.getLast());
            builder.setTitle(journal.getTitle());
            builder.setVolume(journal.getVolume());
            builder.setName(journal.getName());
            if (journal.getDbReference() != null && !journal.getDbReference().isEmpty()) {
                builder.setDbXrefs(journal.getDbReference().stream().map(val -> this.toAvro((DbReferenceType)val)).collect(Collectors.toList()));
            }
            return builder.build();
        }

        @Override
        public JournalType fromAvro(AvroJournalArticle avro) {
            JournalType journal = new JournalType();
            if (avro.getTitle() != null) {
                journal.setTitle(avro.getTitle().toString());
            }
            if (avro.getName() != null) {
                journal.setName(avro.getName().toString());
            }
            if (avro.getFirst() != null) {
                journal.setFirst(avro.getFirst().toString());
            }
            if (avro.getLast() != null) {
                journal.setLast(avro.getLast().toString());
            }
            if (avro.getVolume() != null) {
                journal.setVolume(avro.getVolume().toString());
            }
            if (avro.getDbXrefs() != null) {
                avro.getDbXrefs().forEach(val -> journal.getDbReference().add(this.fromAvro((AvroXref)((Object)val))));
            }
            return journal;
        }

        @Override
        private AvroXref toAvro(DbReferenceType refType) {
            AvroXref.Builder builder = AvroXref.newBuilder();
            builder.setType(refType.getType());
            builder.setId(refType.getId());
            return builder.build();
        }

        @Override
        private DbReferenceType fromAvro(AvroXref avro) {
            DbReferenceType refType = new DbReferenceType();
            refType.setType(avro.getType().toString());
            refType.setId(avro.getId().toString());
            return refType;
        }
    }

    static class AvroSubmissionConverter
    implements Converter<SubmissionType, AvroSubmission> {
        AvroSubmissionConverter() {
        }

        @Override
        public AvroSubmission toAvro(SubmissionType submission) {
            AvroSubmission.Builder builder = AvroSubmission.newBuilder();
            builder.setCitation(submission.getTitle());
            builder.setDatabase(submission.getDb());
            return builder.build();
        }

        @Override
        public SubmissionType fromAvro(AvroSubmission avro) {
            SubmissionType submission = new SubmissionType();
            if (avro.getCitation() != null) {
                submission.setTitle(avro.getCitation().toString());
            }
            submission.setDb(avro.getDatabase().toString());
            return submission;
        }
    }
}

