/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.CanonicalGene;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.EntryType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.GeneNameType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.GeneType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroCanonicalGene;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroGene;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.GNType;

public class AvroCanonicalGeneConverter
implements Converter<CanonicalGene, AvroCanonicalGene> {
    private final AvroGeneConverter geneConverter = new AvroGeneConverter();

    @Override
    public AvroCanonicalGene toAvro(CanonicalGene canGene) {
        AvroCanonicalGene.Builder builder = AvroCanonicalGene.newBuilder();
        builder.setGene(this.geneConverter.toAvro(canGene.getGene()));
        if (canGene.getRelatedGene() != null && !canGene.getRelatedGene().isEmpty()) {
            builder.setRelatedGenes(canGene.getRelatedGene().stream().map(gene -> this.geneConverter.toAvro((GeneType)gene)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public CanonicalGene fromAvro(AvroCanonicalGene avro) {
        CanonicalGene canGene = new CanonicalGene();
        canGene.setGene(this.geneConverter.fromAvro(avro.getGene()));
        if (avro.getRelatedGenes() != null) {
            avro.getRelatedGenes().forEach(val -> canGene.getRelatedGene().add(this.geneConverter.fromAvro((AvroGene)((Object)val))));
        }
        return canGene;
    }

    static class AvroGeneConverter
    implements Converter<GeneType, AvroGene> {
        AvroGeneConverter() {
        }

        @Override
        public AvroGene toAvro(GeneType gene) {
            AvroGene.Builder builder = AvroGene.newBuilder();
            builder.setAccession(gene.getAccession());
            builder.setLength(gene.getLength());
            builder.setName(gene.getGeneName());
            builder.setReviewed(gene.getEntryType() == EntryType.SWISS_PROT);
            builder.setType(this.toAvro(gene.getGeneNameType()));
            return builder.build();
        }

        @Override
        public GeneType fromAvro(AvroGene avro) {
            GeneType gene = new GeneType();
            gene.setAccession(avro.getAccession().toString());
            if (avro.getReviewed().booleanValue()) {
                gene.setEntryType(EntryType.SWISS_PROT);
            } else {
                gene.setEntryType(EntryType.TR_EMBL);
            }
            gene.setLength(avro.getLength());
            gene.setGeneName(avro.getName().toString());
            gene.setGeneNameType(this.fromAvro(avro.getType()));
            return gene;
        }

        @Override
        private GNType toAvro(GeneNameType type) {
            switch (type) {
                case MOD: {
                    return GNType.MOD;
                }
                case ENSEMBL: {
                    return GNType.ENSEMBL;
                }
                case OLN: {
                    return GNType.OLN;
                }
                case ORF: {
                    return GNType.ORF;
                }
                case GENE_NAME: {
                    return GNType.GENE_NAME;
                }
                case MISSING: {
                    return GNType.MISSING;
                }
            }
            return GNType.MISSING;
        }

        @Override
        private GeneNameType fromAvro(GNType type) {
            switch (type) {
                case MOD: {
                    return GeneNameType.MOD;
                }
                case ENSEMBL: {
                    return GeneNameType.ENSEMBL;
                }
                case OLN: {
                    return GeneNameType.OLN;
                }
                case ORF: {
                    return GeneNameType.ORF;
                }
                case GENE_NAME: {
                    return GeneNameType.GENE_NAME;
                }
                case MISSING: {
                    return GeneNameType.MISSING;
                }
            }
            return GeneNameType.MISSING;
        }
    }
}

