/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate;

import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GeneNameType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnGeneName;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnGnNameType;

class GeneAvroXmlConverter
implements Converter<GeneNameType, GnGeneName> {
    private static final String ORF_NAMES = "ORF";
    private static final String ORDERED_LOCUS_NAMES = "ordered locus";
    private static final String SYNONYMS = "synonym";
    private static final String NAME = "primary";

    GeneAvroXmlConverter() {
    }

    @Override
    public GnGeneName toAvro(GeneNameType u) {
        GnGeneName.Builder builder = GnGeneName.newBuilder();
        builder.setName(u.getValue());
        builder.setType(this.convertToAvro(u.getType()));
        return builder.build();
    }

    @Override
    public GeneNameType fromAvro(GnGeneName a) {
        GeneNameType name = new GeneNameType();
        name.setValue(a.getName().toString());
        name.setType(this.convertFromAvro(a.getType()));
        return name;
    }

    GnGnNameType convertToAvro(String type) {
        if (type.equalsIgnoreCase(NAME)) {
            return GnGnNameType.GENAME;
        }
        if (type.equalsIgnoreCase(SYNONYMS)) {
            return GnGnNameType.SYNNAME;
        }
        if (type.equalsIgnoreCase(ORDERED_LOCUS_NAMES)) {
            return GnGnNameType.OLNAME;
        }
        return GnGnNameType.ORFNAME;
    }

    String convertFromAvro(GnGnNameType type) {
        switch (type) {
            case GENAME: {
                return NAME;
            }
            case SYNNAME: {
                return SYNONYMS;
            }
            case OLNAME: {
                return ORDERED_LOCUS_NAMES;
            }
            case ORFNAME: {
                return ORF_NAMES;
            }
        }
        return NAME;
    }
}

