/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.text.NumberFormat;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class BPCPMichaelisConverter
implements Converter<MichaelisConstant, EvidencedString> {
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final ThreadLocal<NumberFormat> numberFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat get() {
            return (NumberFormat)super.get();
        }

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getNumberInstance();
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(NumberFormat value) {
            super.set(value);
        }
    };

    @Override
    public EvidencedString toAvro(MichaelisConstant mc) {
        String val = this.build(mc);
        return ConverterHelper.convert(val, mc.getEvidenceIds());
    }

    @Override
    public MichaelisConstant fromAvro(EvidencedString vs) {
        MichaelisConstant mc = this.build(vs.getKey().toString());
        mc.setEvidenceIds(this.evidenceConverter.fromAvro(vs.getEvidence()));
        return mc;
    }

    private String build(MichaelisConstant mc) {
        StringBuilder km = new StringBuilder();
        String val = this.numberFormatter.get().format(mc.getConstant());
        String val2 = "" + mc.getConstant();
        if (val.contains(".")) {
            val = val2;
        }
        val = val.replace(",", "");
        km.append(val);
        km.append(" ");
        km.append(mc.getUnit().toDisplayNameString());
        km.append(" for ");
        km.append(mc.getSubstrate().getValue());
        return km.toString();
    }

    private MichaelisConstant build(String kmStr) {
        MichaelisConstant km = DefaultCommentFactory.getInstance().buildMichaelisConstant();
        int index = kmStr.indexOf(32);
        String val = kmStr.substring(0, index).trim();
        kmStr = kmStr.substring(index + 1).trim();
        index = kmStr.indexOf(32);
        String unit = kmStr.substring(0, index).trim();
        kmStr = kmStr.substring(index + 5).trim();
        double value = Double.parseDouble(val);
        km.setConstant((float)value);
        km.setUnit(MichaelisConstantUnit.convert(unit));
        km.setSubstrate(DefaultCommentFactory.getInstance().buildSubstrate(kmStr));
        return km;
    }
}

