/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.SourceLine;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.starstar.InternalSectionAvro;

public class InternalSectionConverter
implements Converter<InternalSection, InternalSectionAvro> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public InternalSectionAvro toAvro(InternalSection u) {
        List<SourceLine> sources = u.getSourceLines();
        InternalSectionAvro.Builder builder = InternalSectionAvro.newBuilder();
        if (!sources.isEmpty()) {
            builder.setSource(sources.stream().map(val -> val.getValue()).filter(val -> !Strings.isNullOrEmpty((String)val)).collect(Collectors.toList()));
        }
        if (!u.getInternalLines().isEmpty()) {
            builder.setInternal(u.getInternalLines().stream().map(this::fromInternalLine).collect(Collectors.toList()));
        }
        return builder.build();
    }

    private String fromInternalLine(InternalLine line) {
        return line.getInternalLineType().name() + ":" + line.getValue();
    }

    private InternalLine toInternalLine(String line) {
        int index = line.indexOf(":");
        if (index == -1) {
            return null;
        }
        String type = line.substring(0, index);
        String value = line.substring(index + 1);
        return factory.buildInternalLine(type, value);
    }

    @Override
    public InternalSection fromAvro(InternalSectionAvro a) {
        InternalSection is = factory.buildInternalSection();
        if (a.getSource() != null) {
            is.setSourceLines(a.getSource().stream().map(val -> factory.buildSourceLine(val.toString())).collect(Collectors.toList()));
        }
        if (a.getInternal() != null) {
            is.setInternalLines(a.getInternal().stream().map(val -> val.toString()).map(this::toInternalLine).filter(val -> val != null).collect(Collectors.toList()));
        }
        return is;
    }
}

