/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.basic.impl.JapiBasicService;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultQueryResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultRequestImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.info.InfoService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.QuerySpec;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtField;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtServiceInfo;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.DefaultUniProtRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.JapiUniProtResponseAdapter;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.impl.UniProtServiceInfoImpl;
import uk.ac.ebi.uniprot.dataservice.domain.info.ServiceInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.UniProtServiceInfoObject;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;

final class JapiUniprotServiceImpl
implements UniProtService {
    public static final String NAME_REMOTE_SERVER_URL = "UNIPROT_REMOTE_SERVER_URL";
    private int DEFAULT_ENTRY_PAGE_SIZE = 100;
    private static final Logger logger = LoggerFactory.getLogger(JapiUniprotServiceImpl.class);
    private final BasicService<Response<EntryObject>> service;
    private final InfoService infoService;

    @Inject
    public JapiUniprotServiceImpl(@Named(value="UNIPROT_REMOTE_SERVER_URL") String serverURL, HttpRequestConfig serverConfig, InfoService infoService) {
        this.service = new JapiBasicService<EntryObject>(serverURL, serverConfig, EntryObject.class);
        this.infoService = infoService;
        logger.info("UniProt Service is running against: {}", (Object)serverURL);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query) throws ServiceException {
        return this.getEntries(query, null);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query, EnumSet<QuerySpec> specs) throws ServiceException {
        boolean withIsofrom = this.checkIsofromSpec(specs);
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(withIsofrom);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtEntry, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.entryAdaptor);
    }

    @Override
    public QueryResult<UniProtEntry> getEntries(Query query, EnumSet<QuerySpec> spec, int offset, int pageSize) throws ServiceException {
        if (pageSize == -1) {
            return this.getEntries(query, spec);
        }
        boolean withIsofrom = this.checkIsofromSpec(spec);
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(withIsofrom);
        uniProtRequest.setQuery(query);
        if (pageSize < 10000) {
            uniProtRequest.setCursorMark(null);
        }
        uniProtRequest.setResultCardinality(pageSize);
        uniProtRequest.setResultOffset(offset);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtEntry, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.entryAdaptor);
    }

    @Override
    public UniProtEntry getEntry(String accession) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setWithIsoform(true);
        Query request = UniProtQueryBuilder.accession(accession);
        uniProtRequest.setQuery(request);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        List<EntryObject> results = response.getResults();
        if (results.size() > 0) {
            EntryObject entry = results.get(0);
            return JapiUniProtResponseAdapter.entryAdaptor.adapt(entry);
        }
        return null;
    }

    @Override
    public QueryResult<PrimaryUniProtAccession> getAccessions(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<PrimaryUniProtAccession, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.accessionAdaptor);
    }

    @Override
    public QueryResult<PrimaryUniProtAccession> getAccessions(Query query, EnumSet<QuerySpec> specs) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        uniProtRequest.setWithIsoform(this.checkIsofromSpec(specs));
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<PrimaryUniProtAccession, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.accessionAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Gene>> getGenes(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<Gene>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.geneAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<DatabaseCrossReference>> getXrefs(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<DatabaseCrossReference>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.xrefAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<String>> getECNumbers(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<String>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.ecNumberAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<String>> getProteinNames(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<String>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.proteinNameAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Comment>> getComments(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<Comment>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.commentAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Feature>> getFeatures(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<Feature>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.featureAdaptor);
    }

    @Override
    public QueryResult<UniProtComponent<Keyword>> getKeywords(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtComponent<Keyword>, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.keywordAdaptor);
    }

    @Override
    public QueryResult<UniProtData> getResults(Query query, UniProtData.ComponentType ... components) throws ServiceException {
        return this.getResults(query, (EnumSet<QuerySpec>)null, components);
    }

    @Override
    public QueryResult<UniProtData> getResults(Query query, EnumSet<QuerySpec> specs, UniProtData.ComponentType ... componentTypes) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setWithIsoform(this.checkIsofromSpec(specs));
        uniProtRequest.setRetrieveUniProtEntry(true);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(this.DEFAULT_ENTRY_PAGE_SIZE);
        Response<EntryObject> response = this.service.execute(uniProtRequest);
        return new DefaultQueryResultImpl<UniProtData, EntryObject>(this.service, uniProtRequest, response, JapiUniProtResponseAdapter.JapiUniProtDataAdaptor(componentTypes));
    }

    @Override
    public UniProtServiceInfo getServiceInfo() throws ServiceException {
        Optional<ServiceInfoObject> infoObj = this.infoService.getServiceInfo();
        if (infoObj.isPresent()) {
            UniProtServiceInfoObject uniInfoObj = infoObj.get().getUniProtServiceInfoObject();
            return new UniProtServiceInfoImpl(uniInfoObj.getReleaseNumber(), uniInfoObj.getTremblEntries(), uniInfoObj.getSwissProtEntries());
        }
        long siwssCount = this.getHitCountFromSolr(UniProtQueryBuilder.swissprot());
        long tremblCount = this.getHitCountFromSolr(UniProtQueryBuilder.trembl());
        return new UniProtServiceInfoImpl("", tremblCount, siwssCount);
    }

    private long getHitCountFromSolr(Query query) throws ServiceException {
        DefaultUniProtRequest uniProtRequest = new DefaultUniProtRequest(new DefaultRequestImpl());
        uniProtRequest.setFields(UniProtField.Return.accession);
        uniProtRequest.setQuery(query);
        uniProtRequest.setResultCardinality(0);
        Response<EntryObject> execute = this.service.execute(uniProtRequest);
        return execute.getHitCount();
    }

    @Override
    public void start() {
        this.service.start();
    }

    @Override
    public void stop() {
        this.service.stop();
    }

    @Override
    public boolean isStarted() {
        return this.service.isStarted();
    }

    private boolean checkIsofromSpec(EnumSet<QuerySpec> specs) {
        return specs != null && specs.contains((Object)QuerySpec.WithIsoform);
    }
}

