/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import com.google.inject.Inject;
import org.apache.solr.client.solrj.response.QueryResponse;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicRequest;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultBasicServiceImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultQueryResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultRequestImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.EmptyResponse;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.impl.RequestResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseFactoryProvider;
import uk.ac.ebi.uniprot.dataservice.document.Document;

public class DefaultRequestResponseFactory
implements RequestResponseFactory {
    @Inject
    private ResponseFactoryProvider responseFactoryProvider;

    @Override
    public <D, T extends Response<D>> BasicService<T> createServiceForResponseType(String serverUrl, HttpRequestConfig serverConfig, Class<D> responseType) {
        return new DefaultBasicServiceImpl(this, serverUrl, serverConfig, responseType);
    }

    public <T, D extends Document> QueryResult<T> createQueryResult(BasicService<? extends Response<D>> service, Request request, Response<D> response, ResponseAdaptor<T, D> adaptor) {
        return new DefaultQueryResultImpl<T, D>(service, request, response, adaptor);
    }

    @Override
    public <T, S extends Document> QueryResult<T> createQueryResult(BasicService<? extends Response<S>> service, Request request, Response<S> response, ResponseAdaptor<T, S> adaptor, int maxFetchSize) {
        return new DefaultQueryResultImpl<T, S>(service, request, response, adaptor, maxFetchSize);
    }

    @Override
    public BasicRequest createRequest() {
        return new DefaultRequestImpl();
    }

    @Override
    public <D> Response<D> createResponse(QueryResponse queryResponse, Class<D> responseType) {
        return this.responseFactoryProvider.getFactory(responseType).create(queryResponse, responseType);
    }

    @Override
    public <D> Response<D> createEmptyResponse(Class<D> responseType) {
        return new EmptyResponse();
    }
}

