/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.Request;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.impl.RequestResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.impl.SolrCollection;

class DefaultBasicServiceImpl<R extends Response, T>
implements BasicService {
    protected final String serverURL;
    private final HttpRequestConfig httpRequestConfig;
    private final Class<T> responseType;
    protected SolrClient httpSolrServer;
    private Service serviceDelegate;
    private final RequestResponseFactory factory;
    private static final Logger logger = LoggerFactory.getLogger(DefaultBasicServiceImpl.class);

    public DefaultBasicServiceImpl(RequestResponseFactory factory, String serverURL, HttpRequestConfig serverConfig, Class<T> responseType) {
        this.responseType = responseType;
        this.factory = factory;
        this.serverURL = serverURL;
        this.httpRequestConfig = serverConfig;
        this.serviceDelegate = new ServiceDelegate();
    }

    @Override
    public synchronized void start() {
        Service.State state = this.serviceDelegate.state();
        if (state == Service.State.RUNNING || state == Service.State.STARTING) {
            logger.debug("Service is already Running: " + this.getClass().getSimpleName());
            return;
        }
        if (state == Service.State.TERMINATED || state == Service.State.FAILED) {
            this.serviceDelegate = new ServiceDelegate();
            logger.debug("Service is stopped, will now be restarted: " + this.getClass().getSimpleName());
        }
        logger.debug("Starting service: " + this.getClass().getSimpleName());
        this.serviceDelegate.startAsync();
        this.serviceDelegate.awaitRunning();
        logger.debug("Service started: " + this.getClass().getSimpleName());
        Preconditions.checkNotNull((Object)this.httpSolrServer, (Object)"Solr HTTP Connection Service doesn't after service being started. please Report the issue!");
    }

    @Override
    public synchronized void stop() {
        Service.State state = this.serviceDelegate.state();
        if (state == Service.State.STOPPING || state == Service.State.TERMINATED || state == Service.State.FAILED) {
            logger.debug("Service is already Stopped: " + this.getClass().getSimpleName());
            return;
        }
        logger.debug("Stopping service: " + this.getClass().getSimpleName());
        this.serviceDelegate.stopAsync();
        this.serviceDelegate.awaitTerminated();
        logger.debug("Service stopped: " + this.getClass().getSimpleName());
    }

    @Override
    public boolean isStarted() {
        return this.serviceDelegate.isRunning();
    }

    public Response execute(Request query) throws ServiceException {
        Preconditions.checkState((boolean)this.serviceDelegate.isRunning(), (Object)"Service is not running, please start it before doing anything else.");
        Preconditions.checkNotNull((Object)this.httpSolrServer, (Object)"Solr HTTP Connection Service does not exist, please check!");
        if (query.getQuery().isEmpty() || query.getQuery().isEverything()) {
            return this.factory.createEmptyResponse(this.responseType);
        }
        logger.debug("Sending Request: " + query.toString());
        Map<String, String> solrQueryMap = query.buildQueryMap();
        MapSolrParams solrParams = new MapSolrParams(solrQueryMap);
        try {
            QueryResponse queryResponse = this.httpSolrServer.query((SolrParams)solrParams);
            logger.trace("Response received");
            return this.factory.createResponse(queryResponse, this.responseType);
        }
        catch (IOException | SolrServerException e) {
            String msg = "Error while requesting the service with query: " + query.getQuery();
            throw new ServiceException(msg, e);
        }
        catch (Exception error) {
            error.printStackTrace();
            String msg = "Unexpected error while requesting the service with query: " + query.getQuery();
            throw new ServiceException(msg, error);
        }
    }

    public static String getBuildVersion() {
        try {
            Class<DefaultBasicServiceImpl> clazz = DefaultBasicServiceImpl.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return "UNKNOWN.Not-built-by-UniProt";
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("UniProt-JAPI-Version");
            if (!Strings.isNullOrEmpty((String)value)) {
                return value;
            }
            return "UNKNOWN.Not-set";
        }
        catch (Exception e) {
            return "UNKNOWN.Cannot-get";
        }
    }

    class ServiceDelegate
    extends AbstractIdleService {
        ServiceDelegate() {
        }

        protected void startUp() throws Exception {
            BasicHeader basicHeader = new BasicHeader("JAPI-VERSION", DefaultBasicServiceImpl.getBuildVersion());
            HttpClientBuilder custom = HttpClients.custom();
            custom.setDefaultHeaders(Arrays.asList(basicHeader));
            RequestConfig.Builder builder = RequestConfig.custom();
            builder.setSocketTimeout(DefaultBasicServiceImpl.this.httpRequestConfig.getSocketTimeOut());
            builder.setConnectTimeout(DefaultBasicServiceImpl.this.httpRequestConfig.getConnectionTimeOut());
            builder.setRedirectsEnabled(false);
            RequestConfig build = builder.build();
            custom.setDefaultRequestConfig(build);
            custom.setMaxConnTotal(DefaultBasicServiceImpl.this.httpRequestConfig.getMaxTotalConnections());
            boolean usingCloud = true;
            if (DefaultBasicServiceImpl.this.serverURL.startsWith("http")) {
                usingCloud = false;
            }
            if (usingCloud) {
                String[] split = DefaultBasicServiceImpl.this.serverURL.split(",");
                logger.info("Using cloud client with url: {}", (Object)DefaultBasicServiceImpl.this.serverURL);
                CloudSolrClient cloudSorClient = new CloudSolrClient.Builder().withZkHost(Arrays.asList(split)).build();
                SolrCollection solrCollection = SolrCollection.getSorCollectionFromResponseClassName(DefaultBasicServiceImpl.this.responseType.getSimpleName());
                cloudSorClient.setDefaultCollection(solrCollection.getCollectionName());
                cloudSorClient.setIdField(solrCollection.getCollectionIdFieldName());
                DefaultBasicServiceImpl.this.httpSolrServer = cloudSorClient;
            } else {
                logger.info("Using non-cloud http client with url: {}", (Object)DefaultBasicServiceImpl.this.serverURL);
                CloseableHttpClient client = custom.useSystemProperties().build();
                HttpSolrClient.Builder solrClientbuilder = new HttpSolrClient.Builder(DefaultBasicServiceImpl.this.serverURL);
                DefaultBasicServiceImpl.this.httpSolrServer = ((HttpSolrClient.Builder)solrClientbuilder.withHttpClient((HttpClient)client)).build();
            }
        }

        protected void shutDown() throws Exception {
            if (DefaultBasicServiceImpl.this.httpSolrServer != null) {
                DefaultBasicServiceImpl.this.httpSolrServer.close();
            }
        }
    }
}

