/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.xdb;

public enum DbCategory {
    D2G("2DG", "2D gel"),
    D3S("3DS", "3D structure"),
    EZP("EZP", "Enzyme and pathway"),
    FMD("FMD", "Family and domain"),
    GNE("GNE", "Gene expression"),
    GMA("GMA", "Genome annotation"),
    GO("OTG", "Ontologies"),
    ORG("ORG", "Organism_specific"),
    PGM("PGM", "Phylogenomic"),
    PMM("PMM", "Polymorphism"),
    PPI("PPI", "Protein-protein interaction"),
    PTM("PTM", "PTM"),
    SQL("SEQ", "Sequence databases"),
    OTH("OTH", "Other");

    private String type;
    private String fullname;

    private DbCategory(String type, String fullname) {
        this.type = type;
        this.fullname = fullname;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.fullname;
    }

    public static DbCategory getType(String category) {
        for (DbCategory type : DbCategory.values()) {
            if (!type.getType().equals(category)) continue;
            return type;
        }
        return OTH;
    }
}

