/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.xml.common.KrakenDatatypeConverter;
import uk.ac.ebi.kraken.xml.common.KrakenXMLIterator;
import uk.ac.ebi.kraken.xml.common.XMLWriterException;
import uk.ac.ebi.kraken.xml.uniref.UniRefEntryJAXBConverter;

public class UniRefXMLWriter {
    private UniRefEntryJAXBConverter entryJAXBConverter = new UniRefEntryJAXBConverter();
    private JAXBContext jaxbContext;
    private List<String> unparsedEntries = new ArrayList<String>();
    private List<String> invalidEntries = new ArrayList<String>();
    private boolean quiet = false;

    public void write(UniRefEntry entry, Writer writer) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException("Entry to convert should not be null");
        }
        this.writeEntry(entry, writer);
    }

    public void write(UniRefEntry entry, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.write(entry, (Writer)writer);
    }

    public void write(UniRefEntry entry, OutputStream outputStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.write(entry, (Writer)writer);
    }

    public void write(List<UniRefEntry> entries, Writer writer) throws IOException {
        for (UniRefEntry entry : entries) {
            try {
                this.writeEntry(entry, writer);
            }
            catch (XMLWriterException e) {
                if (this.isQuiet()) continue;
                throw e;
            }
        }
    }

    public void write(List<UniRefEntry> entries, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        this.write(entries, (Writer)writer);
    }

    public void write(List<UniRefEntry> entries, OutputStream outputStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.write(entries, (Writer)writer);
    }

    private void writeEntry(UniRefEntry entry, Writer writer) {
        try {
            BufferedWriter xmlWriter = new BufferedWriter(writer);
            xmlWriter.write(this.entryJAXBConverter.toXML(entry));
            xmlWriter.flush();
        }
        catch (Exception e) {
            throw new XMLWriterException("Entry was not converted to XML: " + e.getMessage(), e, entry.getUniRefEntryId().getValue());
        }
    }

    private void addInvalidEntry(UniRefEntry entry, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getUniRefEntryId().getValue());
        sb.append("\n");
        sb.append(message);
        this.invalidEntries.add(sb.toString());
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
            this.jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniref");
        }
        return this.jaxbContext;
    }

    protected Marshaller prepareSpecialMarshaller() throws JAXBException {
        Marshaller m = this.getJaxbContext().createMarshaller();
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new KrakenDatatypeConverter());
        m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    public List<String> getUnparsedEntries() {
        return this.unparsedEntries;
    }

    public List<String> getInvalidEntries() {
        return this.invalidEntries;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void write(KrakenXMLIterator<UniRefEntry> entryIterator, Writer writer) throws IOException {
        UniRefEntry entry = null;
        while (entryIterator.hasNext()) {
            try {
                entry = entryIterator.next();
                this.writeEntry(entry, writer);
            }
            catch (XMLWriterException e) {
                System.err.println("Entry is not converted to XML. Check invalidEntries list");
                this.addInvalidEntry(entry, e.getMessage());
            }
        }
    }
}

