/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.kraken.interfaces.factories.EntryFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.xml.common.KrakenXMLIterator;
import uk.ac.ebi.kraken.xml.jaxb.uniref.Entry;
import uk.ac.ebi.kraken.xml.uniref.UniRefEntryHandler;

public abstract class UniRefXMLEntryIterator
extends KrakenXMLIterator<UniRefEntry> {
    protected EntryFactory factory;
    private UniRefEntryHandler entryHandler;

    public UniRefXMLEntryIterator(EntryFactory factory, URL url) throws IOException {
        super(url);
        this.factory = factory;
    }

    public UniRefXMLEntryIterator(EntryFactory factory, File file) throws IOException {
        super(file);
        this.factory = factory;
    }

    public UniRefXMLEntryIterator(EntryFactory factory, InputStream inputStream) throws IOException {
        super(inputStream);
        this.factory = factory;
    }

    public UniRefXMLEntryIterator(EntryFactory factory, Reader reader) throws IOException {
        super(reader);
        this.factory = factory;
    }

    @Override
    protected UniRefEntry convertXMLEntry(Object xmlEntry) {
        UniRefEntry answer = null;
        if (this.isXMLEntryType(xmlEntry)) {
            Entry entry = (Entry)xmlEntry;
            answer = this.getEntryHandler().fromXmlBinding(entry);
            answer.getUniRefDatabase().setType(this.getType());
        }
        return answer;
    }

    @Override
    protected String getNameSpace() {
        return "http://uniprot.org/uniref";
    }

    @Override
    protected boolean isXMLEntryType(Object xmlEntry) {
        return xmlEntry instanceof Entry;
    }

    @Override
    protected void configJAXBContext() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniref");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to initialize the JAXBContext");
        }
    }

    private UniRefEntryHandler getEntryHandler() {
        if (this.entryHandler == null) {
            this.entryHandler = new UniRefEntryHandler(this.getType());
        }
        return this.entryHandler;
    }

    protected abstract UniRefDatabaseType getType();

    @Override
    protected abstract String getName();
}

