/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;

public class FeatureHandler<P extends Feature>
implements GenericHandler<P, uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType> {
    private final FeatureHandlerStrategy<P> featureStrategy;
    private final EvidenceReferenceHandler evidenceReferenceHandler;

    public FeatureHandler(FeatureHandlerStrategy<P> featureStrategy, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.featureStrategy = featureStrategy;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    @Override
    public P fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType xmlFeature) {
        String xmlType = xmlFeature.getType();
        FeatureType fType = FeatureType.typeOf(xmlType);
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(fType);
        this.featureStrategy.featureFromXmlBinding(feature, xmlFeature);
        if (!xmlFeature.getEvidence().isEmpty()) {
            feature.setEvidenceIds(this.evidenceReferenceHandler.parseEvidenceIDs(xmlFeature.getEvidence()));
        }
        return (P)feature;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType toXmlBinding(P feature) {
        List<Integer> evs;
        ObjectFactory objectFactory = new ObjectFactory();
        uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType xmlFeature = objectFactory.createFeatureType();
        this.featureStrategy.featureToXmlBinding(feature, xmlFeature);
        if (feature.getType() != null) {
            xmlFeature.setType(feature.getType().getValue());
        }
        if (!feature.getEvidenceIds().isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(feature.getEvidenceIds())).isEmpty()) {
            xmlFeature.getEvidence().addAll(evs);
        }
        return xmlFeature;
    }
}

