/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;

class GenericXmlName {
    private EvidencedStringType fullName;
    private List<EvidencedStringType> shortNameList = new ArrayList<EvidencedStringType>();
    private List<EvidencedStringType> ecNumberList = new ArrayList<EvidencedStringType>();
    private EvidencedStringType allergenName;
    private EvidencedStringType biotechName;
    private List<EvidencedStringType> cdAntigenName = new ArrayList<EvidencedStringType>();
    private List<EvidencedStringType> innName = new ArrayList<EvidencedStringType>();

    GenericXmlName() {
    }

    public EvidencedStringType getFullName() {
        return this.fullName;
    }

    public void setFullName(EvidencedStringType fullName) {
        this.fullName = fullName;
    }

    public List<EvidencedStringType> getShortNameList() {
        return this.shortNameList;
    }

    public void setShortNameList(List<EvidencedStringType> shortNameList) {
        this.shortNameList = shortNameList;
    }

    public List<EvidencedStringType> getEcNumberList() {
        return this.ecNumberList;
    }

    public void setEcNumberList(List<EvidencedStringType> ecNumberList) {
        this.ecNumberList = ecNumberList;
    }

    public void addEcNumber(EvidencedStringType stringType) {
        if (this.containsEC(stringType)) {
            for (EvidencedStringType ref : this.ecNumberList) {
                if (!ref.getValue().equals(stringType.getValue()) || stringType.getEvidence().isEmpty()) continue;
                List<Integer> differences = this.diffList(ref.getEvidence(), stringType.getEvidence());
                ref.getEvidence().addAll(differences);
            }
        } else {
            this.ecNumberList.add(stringType);
        }
    }

    private boolean containsEC(EvidencedStringType stringType) {
        if (!this.ecNumberList.isEmpty()) {
            for (EvidencedStringType ref : this.ecNumberList) {
                if (!ref.getValue().equals(stringType.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private List<Integer> diffList(List<Integer> list1, List<Integer> list2) {
        ArrayList<Integer> result = new ArrayList<Integer>(list2);
        result.removeAll(list1);
        return result;
    }

    public EvidencedStringType getAllergenName() {
        return this.allergenName;
    }

    public void setAllergenName(EvidencedStringType allergenName) {
        this.allergenName = allergenName;
    }

    public EvidencedStringType getBiotechName() {
        return this.biotechName;
    }

    public void setBiotechName(EvidencedStringType biotechName) {
        this.biotechName = biotechName;
    }

    public List<EvidencedStringType> getCdAntigenName() {
        return this.cdAntigenName;
    }

    public void setCdAntigenName(List<EvidencedStringType> cdAntigenName) {
        this.cdAntigenName = cdAntigenName;
    }

    public List<EvidencedStringType> getInnName() {
        return this.innName;
    }

    public void setInnName(List<EvidencedStringType> innName) {
        this.innName = innName;
    }
}

