/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentStatusHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class TextOnlyCommentHandler
implements GenericHandler<TextOnlyComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final CommentStatusHandler commentStatusHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public TextOnlyCommentHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler, CommentStatusHandler commentStatusHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.commentStatusHandler = commentStatusHandler;
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, evidenceReferenceHandler, true);
    }

    @Override
    public TextOnlyComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        if (commentXML == null || commentXML.getText().isEmpty()) {
            return null;
        }
        TextOnlyComment textOnlyComment = (TextOnlyComment)this.commentFactory.buildComment(CommentType.typeOf(commentXML.getType()));
        if (commentXML.getMolecule() != null) {
            textOnlyComment.setMolecule(commentXML.getMolecule().getValue());
        }
        ArrayList<CommentText> commentTexts = new ArrayList<CommentText>();
        for (EvidencedStringType val : commentXML.getText()) {
            EvidencedValue evText = this.evidencedValueHandler.fromXmlBinding(val);
            CommentText commentText = this.commentFactory.buildCommentText();
            commentText.setValue(evText.getValue());
            commentText.setEvidenceIds(evText.getEvidenceIds());
            this.commentStatusHandler.setCommentStatusFromXml(val, commentText);
            commentTexts.add(commentText);
        }
        textOnlyComment.setTexts(commentTexts);
        return textOnlyComment;
    }

    void setCommentType(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML, TextOnlyComment textOnlyComment) {
        commentXML.setType(textOnlyComment.getCommentType().toXmlDisplayName());
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(TextOnlyComment textOnlyComment) {
        if (textOnlyComment == null) {
            return null;
        }
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        this.setCommentType(commentXML, textOnlyComment);
        if (!Strings.isNullOrEmpty((String)textOnlyComment.getMolecule())) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setValue(textOnlyComment.getMolecule());
            commentXML.setMolecule(mol);
        }
        if (textOnlyComment.getTexts().isEmpty()) {
            EvidencedValue evText = DefaultUniProtFactory.getInstance().buildEvidencedValue();
            evText.setValue(textOnlyComment.getValue());
            evText.setEvidenceIds(textOnlyComment.getEvidenceIds());
            EvidencedStringType evidencedStringType = this.evidencedValueHandler.toXmlBinding(evText);
            if (textOnlyComment.getCommentStatus() != null) {
                this.commentStatusHandler.setCommentStatusToXml(textOnlyComment, evidencedStringType);
            }
            commentXML.getText().add(evidencedStringType);
        } else {
            for (CommentText text : textOnlyComment.getTexts()) {
                EvidencedStringType evidencedStringType = this.evidencedValueHandler.toXmlBinding(text);
                if (text.getCommentStatus() != null) {
                    this.commentStatusHandler.setCommentStatusToXml(text, evidencedStringType);
                }
                commentXML.getText().add(evidencedStringType);
            }
        }
        return commentXML;
    }
}

